/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Group;
import rs.petcom.master.dal.product.GroupProduct;
import rs.petcom.master.dal.product.Product;

public class GroupProductDialogController
implements DialogController {
    private ScreensController controller;
    private Group selectedGroup;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<GroupProduct> table;
    @FXML
    private TableColumn<GroupProduct, String> tcCode;
    @FXML
    private TableColumn<GroupProduct, String> tcName;
    @FXML
    private TableColumn<GroupProduct, String> tcBarCode;
    @FXML
    private TextField tfFilter;
    @FXML
    private ColorPicker cpGroupProduct;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
        }
        this.selectedGroup = (Group)parameter.get("selectedGroup");
        this.loadGroupProductTabel();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        this.tcCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<GroupProduct, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<GroupProduct, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Product.getByID(((GroupProduct)param.getValue()).getProductID(), GroupProductDialogController.this.controller)).name("Code").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tcName.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<GroupProduct, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<GroupProduct, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Product.getByID(((GroupProduct)param.getValue()).getProductID(), GroupProductDialogController.this.controller)).name("ShortName").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<GroupProduct, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<GroupProduct, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject(((GroupProduct)param.getValue()).getProductID(), GroupProductDialogController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<GroupProduct>(){

            public void changed(ObservableValue<? extends GroupProduct> observable, GroupProduct oldValue, GroupProduct newValue) {
                if (newValue == null) {
                    GroupProductDialogController.this.cpGroupProduct.setDisable(true);
                    GroupProductDialogController.this.cbActive.setDisable(true);
                } else {
                    GroupProductDialogController.this.cpGroupProduct.setDisable(false);
                    GroupProductDialogController.this.cpGroupProduct.setValue((Object)Color.valueOf((String)newValue.getColor()));
                    GroupProductDialogController.this.cbActive.setDisable(false);
                    GroupProductDialogController.this.cbActive.setSelected(newValue.isActive());
                }
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Upisivanje po\u010detnog stanja u toku...", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                ((GroupProduct)GroupProductDialogController.this.table.getSelectionModel().getSelectedItem()).setColor("#" + Integer.toHexString(((Color)GroupProductDialogController.this.cpGroupProduct.getValue()).hashCode()).substring(0, 6).toUpperCase());
                ((GroupProduct)GroupProductDialogController.this.table.getSelectionModel().getSelectedItem()).setActive(GroupProductDialogController.this.cbActive.isSelected());
                ((GroupProduct)GroupProductDialogController.this.table.getSelectionModel().getSelectedItem()).update(GroupProductDialogController.this.controller);
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisivanja artikala. ", this.rootPane.getScene().getWindow());
        });
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int res = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (res == ScreensController.MODAL_RESULT_OK) {
            GroupProduct groupProduct = new GroupProduct();
            groupProduct.setGroupID(this.selectedGroup.getGroupID());
            groupProduct.setProductID(((Product)hm.get("product")).getProductID());
            groupProduct.setColor("#" + Integer.toHexString(((Color)this.cpGroupProduct.getValue()).hashCode()).substring(0, 6).toUpperCase());
            groupProduct.setActive(this.cbActive.isSelected());
            groupProduct.insert(this.controller);
        }
        this.loadGroupProductTabel();
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            // empty if block
        }
    }

    private void loadGroupProductTabel() {
        this.table.setItems(GroupProduct.getProductListByGroup(this.selectedGroup, this.controller));
        this.cbActive.setSelected(false);
    }
}

