/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Group;

public class GroupDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private ScreensController controller;
    private Group group;
    private File picture;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfGroupName;
    @FXML
    private CheckBox cbActive;
    @FXML
    private ComboBox<Group> cbParentGroup;
    @FXML
    private ColorPicker cpGroupColor;
    @FXML
    private ImageView imageView;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.group = (Group)parameter.get("group");
        this.fillGroup();
        this.fillGroupComboBox();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        if (this.group != null) {
            this.group.setName(this.tfGroupName.getText().toUpperCase().trim());
            this.group.setActive(this.cbActive.isSelected());
            this.group.setParentGroupID(((Group)this.cbParentGroup.getSelectionModel().getSelectedItem()).getGroupID());
            this.group.setSysDTEdit(new Date());
            this.group.setSysUserEditID(this.controller.getUser().getUserID());
            this.group.setColor("#" + Integer.toHexString(((Color)this.cpGroupColor.getValue()).hashCode()).substring(0, 6).toUpperCase());
            if (this.picture != null) {
                this.group.setPicture(new Image(this.picture.toURI().toString()));
            }
            this.group.updateGroup(this.controller, this.picture);
        } else {
            this.group = new Group();
            this.group.setName(this.tfGroupName.getText().toUpperCase().trim());
            this.group.setActive(this.cbActive.isSelected());
            this.group.setParentGroupID(((Group)this.cbParentGroup.getSelectionModel().getSelectedItem()).getGroupID());
            this.group.setSysDTCreated(new Date());
            this.group.setSysUserAddID(this.controller.getUser().getUserID());
            this.group.setColor("#" + Integer.toHexString(((Color)this.cpGroupColor.getValue()).hashCode()).substring(0, 6).toUpperCase());
            if (this.picture != null) {
                this.group.setPicture(new Image(this.picture.toURI().toString()));
            }
            this.group.createNewGroup(this.controller, this.picture);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void imageAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.*"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"})});
        this.picture = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (this.picture != null) {
            this.imageView.setImage(new Image(this.picture.toURI().toString()));
            this.imageView.setPreserveRatio(true);
        } else {
            System.out.println("nema slike");
        }
    }

    private void fillGroup() {
        if (this.group != null) {
            this.tfGroupName.setText(this.group.getName().trim());
            this.cbActive.setSelected(this.group.isActive());
            this.cpGroupColor.setValue((Object)Color.valueOf((String)this.group.getColor()));
            this.imageView.setImage(this.group.getPicture());
            this.imageView.setPreserveRatio(true);
        } else {
            this.tfGroupName.setText("");
            this.cbActive.setSelected(false);
        }
    }

    private void fillGroupComboBox() {
        Group parentGroup = new Group(-1, "Bez nadredjene grupe");
        this.cbParentGroup.getItems().add((Object)parentGroup);
        for (Group g : Group.getList("", this.controller)) {
            if (this.group != null) {
                if (this.group.getGroupID() == g.getGroupID()) continue;
                this.cbParentGroup.getItems().add((Object)g);
                continue;
            }
            this.cbParentGroup.getItems().add((Object)g);
        }
        if (this.group != null) {
            this.cbParentGroup.getSelectionModel().select(this.group.getParentGroupID());
        } else {
            this.cbParentGroup.getSelectionModel().select(0);
        }
    }
}

