/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Excise;

public class ExciseDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    private Excise selectedExcise;
    @FXML
    private TextField tfNaziv;
    @FXML
    private TextField tfValue;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblTitle;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.lblTitle.setText((String)this.parameter.get("title"));
        this.selectedExcise = (Excise)parameter.get("selectedExcise");
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        if (this.selectedExcise != null) {
            this.fillExciseData(this.selectedExcise);
        }
        this.tfValue.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.contains(".") && newValue.substring(newValue.length() - 4, newValue.length() - 3).equals(".")) {
                    ExciseDialogController.this.tfValue.setText(oldValue);
                }
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    ExciseDialogController.this.tfValue.setText(oldValue);
                }
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void post(ActionEvent evt) {
        Excise excise = new Excise();
        excise.setName(this.tfNaziv.getText());
        excise.setValue(Double.parseDouble(this.tfValue.getText().trim()));
        if (this.selectedExcise == null) {
            excise.insert(this.controller);
        } else {
            excise.setExciseId(this.selectedExcise.getExciseId());
            excise.update(this.controller);
        }
        this.parameter.put("selectedExcise", excise);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)evt.getSource()).getScene().getWindow()).close();
    }

    private void fillExciseData(Excise excise) {
        this.tfNaziv.setText(excise.getName());
        this.tfValue.setText(String.valueOf(excise.getValue()));
    }
}

