/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Excise;

public class ExciseController
implements ControlledScreen {
    private ScreensController controller;
    private Excise selectedExcise;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Excise> tvExcise;
    @FXML
    private TableColumn<Excise, String> tcName;
    @FXML
    private TableColumn<Excise, Double> tcValue;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadExciseList();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.tvExcise.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedExcise = newValue;
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ExciseController.this.loadExciseList();
            }
        });
    }

    @FXML
    public void insertExcise(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Kreiranje nove akcize");
        this.controller.showModalDialog("Kreiranje novog gotovinskog kupca", ScreensController.DIALOG_ADD_EXCISE, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadExciseList();
    }

    @FXML
    public void deleteExcise(ActionEvent event) {
        if (this.selectedExcise == null) {
            this.controller.alert("Greska!", "Morate izabrati akcizu koju zelite da obrisete", this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedExcise.delete(this.controller);
        this.loadExciseList();
    }

    @FXML
    public void updateExcise(ActionEvent evt) {
        if (this.selectedExcise == null) {
            this.controller.alert("Greska!", "Morate izabrati gotovinskog kupca kome zelite da izmenite podatke", this.rootPane.getScene().getWindow());
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Izmena akcize");
        hm.put("selectedExcise", this.selectedExcise);
        this.controller.showModalDialog("Izmena akcize", ScreensController.DIALOG_ADD_EXCISE, hm, (Window)((Stage)((Node)evt.getSource()).getScene().getWindow()));
        this.loadExciseList();
    }

    @FXML
    public void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                ExciseController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    private void loadExciseList() {
        this.tvExcise.setItems(Excise.getList(this.controller, this.tfFilter.getText().trim()));
    }

    private void writeToExcel() {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lista akciza");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Naziv");
        header.createCell(1).setCellValue("Vrednost");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        int index = 1;
        for (Excise excise : this.tvExcise.getItems()) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(excise.getName());
            row.createCell(1).setCellValue(excise.getValue());
            ++index;
        }
        try {
            File theDir = new File(this.controller.getSettings().getJasperToPDF() + "Akcize");
            if (!theDir.exists()) {
                try {
                    theDir.mkdir();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(theDir + File.separator + "Akcize.xlsx");
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

