/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;

public class DepartmentNewDialogTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Department selectedDepartment;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfShortName;
    @FXML
    private TextField tfCode;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedDepartment = (Department)parameter.get("selectedDepartment");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        for (Object o : Object.getList(this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
        this.fillData();
    }

    @Override
    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void post(ActionEvent event) {
        if (!this.validate()) {
            return;
        }
        if (this.selectedDepartment != null) {
            this.selectedDepartment.setName(this.tfName.getText().trim());
            this.selectedDepartment.setShortName(this.tfShortName.getText().trim());
            this.selectedDepartment.setCode(this.tfCode.getText().trim());
            this.selectedDepartment.setActive(this.cbActive.isSelected());
            this.selectedDepartment.setObjectID(((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
            this.selectedDepartment.update(this.controller);
        } else {
            this.selectedDepartment = new Department();
            this.selectedDepartment.setName(this.tfName.getText().trim());
            this.selectedDepartment.setShortName(this.tfShortName.getText().trim());
            this.selectedDepartment.setCode(this.tfCode.getText().trim());
            this.selectedDepartment.setActive(this.cbActive.isSelected());
            this.selectedDepartment.setObjectID(((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID());
            this.selectedDepartment.insert(this.controller);
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private boolean validate() {
        if (this.tfName.getText() == null || this.tfShortName.getText() == null || this.tfCode.getText() == null) {
            this.controller.alert("Upozorenje", "Popunite sva polja!", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }

    private void fillData() {
        if (this.selectedDepartment != null) {
            this.tfName.setText(this.selectedDepartment.getName());
            this.tfShortName.setText(this.selectedDepartment.getShortName());
            this.tfCode.setText(this.selectedDepartment.getCode());
            this.cbActive.setSelected(this.selectedDepartment.isActive());
            for (Object object : this.cbObject.getItems()) {
                if (object.getObjectID() != this.selectedDepartment.getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)object);
            }
        } else {
            this.tfName.setText("");
            this.tfShortName.setText("");
            this.tfCode.setText("");
            this.cbActive.setSelected(false);
        }
    }
}

