/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;

public class DepartmentConfigControllerTrgovina
implements ControlledScreen {
    private ScreensController controller;
    private Department selectedDepartment;
    private HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<Department> tableObject;
    @FXML
    private TableColumn<Department, String> columnName;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadTable();
    }

    public void initialize() {
        this.tableObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                DepartmentConfigControllerTrgovina.this.selectedDepartment = newValue;
            }
        });
        this.tableObject.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.hMap.put("selectedDepartment", null);
        this.controller.showModalDialog("Kreiranje novog odeljenja", ScreensController.DIALOG_ADD_DEPARTMENT, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tableObject.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedDepartment != null) {
            this.hMap.put("selectedDepartment", this.selectedDepartment);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena odeljenja", ScreensController.DIALOG_ADD_DEPARTMENT, this.hMap, this.rootPane.getScene().getWindow());
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati odeljenje iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
    }

    @FXML
    private void actionExcel() {
    }

    private void loadTable() {
        this.tableObject.getSelectionModel().clearSelection();
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tableObject.setItems(Department.getList(this.controller.getObject(), this.controller.getSettings().getConnection()));
    }
}

