/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;

public class DepartmentBackofficeSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    ScreensController controller;
    Product product;
    Department department;
    ObservableList<Department> existedDepartment;
    ObservableList<Department> departmentList;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Department> table;
    @FXML
    TableColumn<Department, String> tcName;
    @FXML
    TextField tfFilter;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.product = (Product)parameter.get("product");
        this.existedDepartment = (ObservableList)parameter.get("departments");
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.populateTable();
        this.tfFilter.setText("");
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DepartmentBackofficeSelectDialogController.this.populateTable();
            }
        });
        this.tfFilter.requestFocus();
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.department = (Department)this.table.getSelectionModel().getSelectedItem();
        this.parameters.put("department", this.department);
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    private void populateTable() {
        boolean exist = false;
        for (Department dep : Department.getList(this.controller.getObject(), this.controller.getSettings().getConnection())) {
            exist = false;
            for (Department existDepartment : this.existedDepartment) {
                if (existDepartment.getDepartmentID() != dep.getDepartmentID()) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            this.table.getItems().add((Object)dep);
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.department = (Department)this.table.getSelectionModel().getSelectedItem();
            this.parameters.put("department", this.department);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

