/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;

public class DeferredSelectDialogController
implements DialogController {
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private HashMap<String, Object> parameters;
    private ScreensController controller;
    private Deferred selectedDeferred;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Deferred> tableDeferred;
    @FXML
    TableColumn<Deferred, String> tcName;
    @FXML
    TableColumn<Deferred, String> tcSurname;
    @FXML
    TextField tfFilter;

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcSurname.setCellValueFactory((Callback)new PropertyValueFactory("surname"));
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.populateTable();
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.selectedDeferred = (Deferred)this.tableDeferred.getSelectionModel().getSelectedItem();
        this.parameters.put("selectedDeferred", this.selectedDeferred);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void populateTable() {
        this.tableDeferred.getItems().clear();
        this.tableDeferred.setItems(Deferred.getDeferredsList(this.controller, this.tfFilter.getText()));
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.selectedDeferred = (Deferred)this.tableDeferred.getSelectionModel().getSelectedItem();
            this.parameters.put("selectedDeferred", this.selectedDeferred);
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        }
    }

    @FXML
    private void newBuyer() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedDeferred", null);
        this.controller.showModalDialog("Kreiranje kupca", ScreensController.DIALOG_ADD_DEFERRED, hm, this.rootPane.getScene().getWindow());
        this.populateTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

