/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;

public class DeferredNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Deferred selectedDeferred;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfSurname;
    @FXML
    private TextField tfPhoneNumber;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfMaxDaysDeferred;
    @FXML
    private TextField tfMaxAmount;
    @FXML
    private TextField tfCurrentAmount;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfEmail;
    @FXML
    private CheckBox cbBlocked;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.tfPhoneNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    DeferredNewDialogController.this.tfPhoneNumber.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        this.tfMaxDaysDeferred.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    DeferredNewDialogController.this.tfMaxDaysDeferred.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        this.tfMaxAmount.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    DeferredNewDialogController.this.tfMaxAmount.setText(oldValue);
                }
            }
        });
        this.controller = (ScreensController)parameter.get("controller");
        this.tfCurrentAmount.setText("0.00");
        this.tfCurrentAmount.setDisable(true);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.selectedDeferred = (Deferred)parameter.get("selectedDeferred");
        this.loadDeffered();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (!this.validate()) {
            return;
        }
        if (this.selectedDeferred != null) {
            this.selectedDeferred.setName(this.tfName.getText().trim());
            this.selectedDeferred.setSurname(this.tfSurname.getText().trim());
            this.selectedDeferred.setPhoneNumber(this.tfPhoneNumber.getText().trim());
            this.selectedDeferred.setAddress(this.tfAddress.getText().trim());
            this.selectedDeferred.setCity(this.tfCity.getText().trim());
            this.selectedDeferred.seteMail(this.tfEmail.getText().trim());
            this.selectedDeferred.setMaxDaysDeferred(Integer.parseInt(this.tfMaxDaysDeferred.getText().trim()));
            this.selectedDeferred.setMaxAmount(Double.parseDouble(this.tfMaxAmount.getText().trim()));
            this.selectedDeferred.setBlocked(this.cbBlocked.isSelected());
            this.selectedDeferred.update(this.controller);
        } else {
            this.selectedDeferred = new Deferred();
            this.selectedDeferred.setName(this.tfName.getText().trim());
            this.selectedDeferred.setSurname(this.tfSurname.getText().trim());
            this.selectedDeferred.setPhoneNumber(this.tfPhoneNumber.getText().trim());
            this.selectedDeferred.setAddress(this.tfAddress.getText().trim());
            this.selectedDeferred.setCity(this.tfCity.getText().trim());
            this.selectedDeferred.seteMail(this.tfEmail.getText().trim());
            this.selectedDeferred.setMaxDaysDeferred(Integer.parseInt(this.tfMaxDaysDeferred.getText().trim()));
            this.selectedDeferred.setMaxAmount(Double.parseDouble(this.tfMaxAmount.getText().trim()));
            this.selectedDeferred.insert(this.controller);
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void loadDeffered() {
        if (this.selectedDeferred != null) {
            this.tfName.setText(this.selectedDeferred.getName().trim());
            this.tfSurname.setText(this.selectedDeferred.getSurname().trim());
            this.tfPhoneNumber.setText(this.selectedDeferred.getPhoneNumber());
            this.tfAddress.setText(this.selectedDeferred.getAddress());
            this.tfCity.setText(this.selectedDeferred.getCity());
            this.tfEmail.setText(this.selectedDeferred.geteMail());
            this.tfMaxDaysDeferred.setText(String.valueOf(this.selectedDeferred.getMaxDaysDeferred()).trim());
            this.tfMaxAmount.setText(String.valueOf(this.selectedDeferred.getMaxAmount()).trim());
            this.tfCurrentAmount.setText(String.valueOf(this.selectedDeferred.getCurrentAmount()).trim());
            this.cbBlocked.setSelected(this.selectedDeferred.isBlocked());
        } else {
            this.tfName.setText("");
            this.tfSurname.setText("");
            this.tfPhoneNumber.setText("");
            this.tfAddress.setText("");
            this.tfCity.setText("");
            this.tfEmail.setText("");
            this.tfMaxDaysDeferred.setText("");
            this.tfMaxAmount.setText("");
            this.cbBlocked.setSelected(false);
        }
    }

    private boolean validate() {
        if (this.tfName.getText() == null || this.tfSurname.getText() == null || this.tfPhoneNumber.getText() == null || this.tfAddress.getText() == null || this.tfCity.getText() == null || this.tfEmail.getText() == null || this.tfMaxDaysDeferred.getText() == null || this.tfMaxAmount.getText() == null || this.tfCurrentAmount.getText() == null) {
            this.controller.alert("Upozorenje", "Popunite sva polja!", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }
}

