/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;

public class DatabaseBackUpController
implements ControlledScreen {
    ScreensController controller;
    private static final Logger LOGGER = Logger.getLogger("global");
    @FXML
    private BorderPane reportPane;
    @FXML
    private BorderPane rootPane;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/reportsTrgovina.css");
        }
    }

    @FXML
    private void export() {
        this.makeBackUp(new File(this.controller.getSettings().getJasperToPDF()));
    }

    public synchronized boolean makeBackUp(File dir) {
        boolean[] success = new boolean[]{false};
        if (dir == null) {
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("JavaFX BackUp");
            File defaultDirectory = new File("C:/TMaster");
            chooser.setInitialDirectory(defaultDirectory);
            File selectedDirectory = chooser.showDialog(this.rootPane.getScene().getWindow());
            String path = selectedDirectory.getAbsolutePath();
            if (path == null) {
                return false;
            }
            dir = new File(path);
        }
        File buDir = dir;
        Date tDate = new Date();
        Date datum = tDate;
        if (datum != null) {
            try {
                success[0] = this.doBackupToDir(buDir);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return success[0];
    }

    public boolean doBackupToDir(File dir) throws Exception {
        boolean success = false;
        if (dir == null) {
            dir = new File(this.controller.getSettings().getFiscalFolder());
        }
        String buPath = new File(dir, "" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date())).getAbsolutePath();
        success = this.backup(buPath);
        return success;
    }

    public synchronized boolean backup(String buPath) {
        String savePath = "\"" + buPath + "\\backup.sql\"";
        String command = "mysqldump -u" + this.controller.getSettings().getUsername() + " -p " + this.controller.getSettings().getPassword() + " " + this.controller.getSettings().getDatabase() + " -r " + savePath;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command});
            int processComplete = p.waitFor();
            if (processComplete == 0) {
                return true;
            }
            LOGGER.info("Neuspesno kreiranje baze. " + command);
            return false;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }
}

