/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;

public class DataExportController
implements ControlledScreen {
    ScreensController controller;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    private BorderPane rootPane;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/reportsTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateTo.setConverter(this.converter);
        this.dateFrom.setValue((Object)LocalDate.now());
        this.dateTo.setValue((Object)LocalDate.now());
    }

    @FXML
    private void export() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            System.out.println(pathWithoutName);
            if (file != null) {
                String filePath = file.getAbsolutePath();
                if (!filePath.toUpperCase().endsWith(".CSV")) {
                    filePath = filePath + ".xml";
                }
                String query = "select o.ObjectID, b.BarCode, dd.Quantity, dd.PriceWithDiscount, d.Number, DATE(d.Date) as Datum from documentdetails dd left join document d on d.DocumentID = dd.DocumentID \t\t\t\t\tand d.DocumentTypeID = 3 \t\t\t\t\tand d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t\t\t\t\tfrom documentrelationship dr  \t\t\t\t\t\t\t\t\t\t\twhere dr.RelationshipTypeID = 2) join pointofsale pos on pos.PointOfSaleID = d.PointOfSaleID\t join object o on o.ObjectID = pos.ObjectID join workday w on w.WorkDayID = d.WorkDayID \t\t\t\tand w.Date >=  ?\t\t\t\t\tand w.Date <= ? join product p on p.ProductID = dd.ProductID join barcode b on b.ProductID = p.ProductID\t group by dd.DocumentDetailsID order by dd.DocumentDetailsID";
                try {
                    PreparedStatement ps = this.controller.getSettings().getConnection().prepareStatement(query);
                    ps.setDate(1, new Date(Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()).getTime()));
                    ps.setDate(2, new Date(Settings.fromLocalDate((LocalDate)this.dateTo.getValue()).getTime()));
                    ResultSet rs = ps.executeQuery();
                    PrintWriter writer = new PrintWriter(filePath, "UTF-8");
                    writer.println("SHOP;BARCODE;QUANTITY;PRICE;RECEIPTNUMBER;RECEIPTDATE");
                    while (rs.next()) {
                        StringBuilder sBuilder = new StringBuilder();
                        writer.println(sBuilder.append(rs.getInt("ObjectID")).append(";").append(rs.getString("BarCode")).append(";").append(Settings.getNumberFormat(2, false).format(rs.getDouble("Quantity"))).append(";").append(Settings.getNumberFormat(2, false).format(rs.getDouble("PriceWithDiscount"))).append(";").append(rs.getInt("Number")).append(";").append(new SimpleDateFormat("dd/MM/yyyy").format(rs.getDate("Datum"))).toString().replace(",", "."));
                    }
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

