/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.person.Address;

public class CompanyConfigControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    ObservableList<CompanyConfig> companyList;
    CompanyConfig selectedCompany;
    HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<CompanyConfig> tableCompany;
    @FXML
    private TableColumn<CompanyConfig, String> columnName;
    @FXML
    private TableColumn<CompanyConfig, String> columnAddress;
    @FXML
    private TableColumn<CompanyConfig, String> columnCity;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadTable();
    }

    public void initialize() {
        this.tableCompany.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<CompanyConfig>(){

            public void changed(ObservableValue<? extends CompanyConfig> observable, CompanyConfig oldValue, CompanyConfig newValue) {
                CompanyConfigControllerTrgovina.this.selectedCompany = newValue;
            }
        });
        this.tableCompany.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.controller.showModalDialog("Kreiranje novog objekta", ScreensController.DIALOG_ADD_COMPANY, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tableCompany.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedCompany != null) {
            this.hMap.put("selectedCompany", this.selectedCompany);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena objekta", ScreensController.DIALOG_ADD_COMPANY, this.hMap, this.rootPane.getScene().getWindow());
            this.selectedCompany = (CompanyConfig)this.hMap.get("selectedObject");
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati objekat iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
        this.hMap.remove("selectedCompany");
    }

    @FXML
    private void actionExcel() {
    }

    private void loadTable() {
        this.tableCompany.getSelectionModel().clearSelection();
        this.companyList = CompanyConfig.getList(this.controller);
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnAddress.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CompanyConfig, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<CompanyConfig, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Address.getByID(((CompanyConfig)param.getValue()).getAddressID(), CompanyConfigControllerTrgovina.this.controller.getSettings().getConnection())).name("Address").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.columnCity.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CompanyConfig, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<CompanyConfig, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Address.getByID(((CompanyConfig)param.getValue()).getAddressID(), CompanyConfigControllerTrgovina.this.controller.getSettings().getConnection())).name("City").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tableCompany.setItems(this.companyList);
    }
}

