/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class CashBuyerController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<CashBuyer> cashBuyerList = FXCollections.observableArrayList();
    private CashBuyer selectedBuyer;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<CashBuyer> tvCashBuyer;
    @FXML
    private TableColumn<CashBuyer, String> tcNaziv;
    @FXML
    private TableColumn<CashBuyer, String> tcPib;
    @FXML
    private TableColumn<CashBuyer, String> tcMB;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.cashBuyerList = CashBuyer.getCashBuyerList(this.controller.getSettings().getConnection());
        this.loadPersonsList();
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CashBuyerController.this.loadPersonsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    private void loadPersonsList() {
        this.cashBuyerList = CashBuyer.getCashBuyerList(this.tfFilter.getText(), this.controller.getSettings().getConnection());
        this.tvCashBuyer.setItems(this.cashBuyerList);
    }

    public void initialize() {
        this.tcNaziv.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcPib.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.tcMB.setCellValueFactory((Callback)new PropertyValueFactory("MB"));
        this.tvCashBuyer.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedBuyer = newValue;
        });
    }

    @FXML
    public void insertCashBuyer(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Kreiranje novog gotovinskog kupca");
        this.controller.showModalDialog("Kreiranje novog gotovinskog kupca", ScreensController.DIALOG_ADD_CASH_BUYER, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tvCashBuyer.getSelectionModel().clearSelection();
        this.loadPersonsList();
    }

    @FXML
    public void deleteCashBuyer(ActionEvent event) {
        if (this.selectedBuyer == null) {
            this.controller.alert("Greska!", "Morate izabrati gotovinskog kupca koga zelite da obrisete", this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedBuyer.delete(this.selectedBuyer.getCashBuyerID(), this.controller.getSettings().getConnection());
        this.tvCashBuyer.getSelectionModel().clearSelection();
        this.loadPersonsList();
    }

    @FXML
    public void updateCashBuyer(ActionEvent evt) {
        if (this.selectedBuyer == null) {
            this.controller.alert("Greska!", "Morate izabrati gotovinskog kupca kome zelite da izmenite podatke", this.rootPane.getScene().getWindow());
            return;
        }
        Person person = Person.getByPIB(this.selectedBuyer.getPIB(), this.controller.getSettings().getConnection());
        if (person != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("personCategory", PersonCategory.getByName(PersonCategory.BUYER, this.controller.getSettings().getConnection()).getName());
            hm.put("selectedPerson", person);
            this.controller.showModalDialog("Izmena podataka", ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)evt.getSource()).getScene().getWindow()));
        } else {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("title", "Izmena podataka gotovinskog kupca");
            hm.put("selectedBuyer", this.selectedBuyer);
            this.controller.showModalDialog("Izmena podataka gotovinskog kupca", ScreensController.DIALOG_ADD_CASH_BUYER, hm, (Window)((Stage)((Node)evt.getSource()).getScene().getWindow()));
            this.tvCashBuyer.getSelectionModel().clearSelection();
        }
        this.loadPersonsList();
    }

    @FXML
    public void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                CashBuyerController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    private void writeToExcel() {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lista gotovinskih kupaca");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Naziv");
        header.createCell(1).setCellValue("PIB");
        header.createCell(2).setCellValue("MB");
        header.createCell(3).setCellValue("Adresa");
        header.createCell(4).setCellValue("Grad");
        header.createCell(5).setCellValue("Postanski broj");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 4100);
        sheet.setColumnWidth(3, 9600);
        sheet.setColumnWidth(4, 4100);
        sheet.setColumnWidth(5, 4100);
        int index = 1;
        for (CashBuyer cashBuyer : this.cashBuyerList) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(cashBuyer.getName());
            row.createCell(1).setCellValue(cashBuyer.getPIB());
            row.createCell(1).setCellValue(cashBuyer.getMB());
            row.createCell(2).setCellValue(cashBuyer.getAddress());
            row.createCell(3).setCellValue(cashBuyer.getCity());
            row.createCell(4).setCellValue(cashBuyer.getZIP());
            ++index;
        }
        try {
            File theDir = new File(this.controller.getSettings().getJasperToPDF() + "Gotovinski_kupci");
            if (!theDir.exists()) {
                try {
                    theDir.mkdir();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(theDir + File.separator + "Gotovinski_kupci.xlsx");
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

