/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;

public class AditionalFieldSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    ScreensController controller;
    Product product;
    AditionalField selectedAditionalField;
    AditionalFieldDetails selectedAditionalFieldDetails;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<AditionalField> tableAditionalFields;
    @FXML
    TableColumn<AditionalField, String> tcNameAditionalField;
    @FXML
    TableView<AditionalFieldDetails> tableAditionalFieldDetails;
    @FXML
    TableColumn<AditionalFieldDetails, String> tcNameAditionalFieldDetails;
    @FXML
    TextField tfFilter;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.product = (Product)parameter.get("product");
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.populateTable();
        this.tfFilter.setText("");
        this.tcNameAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcNameAditionalFieldDetails.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tableAditionalFields.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<AditionalField>(){

            public void onChanged(ListChangeListener.Change<? extends AditionalField> arg0) {
                AditionalFieldSelectDialogController.this.selectedAditionalField = (AditionalField)AditionalFieldSelectDialogController.this.tableAditionalFields.getSelectionModel().getSelectedItem();
                AditionalFieldSelectDialogController.this.loadAditionalFieldDetails();
            }
        });
        this.tableAditionalFieldDetails.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<AditionalFieldDetails>(){

            public void onChanged(ListChangeListener.Change<? extends AditionalFieldDetails> arg0) {
                AditionalFieldSelectDialogController.this.selectedAditionalFieldDetails = (AditionalFieldDetails)AditionalFieldSelectDialogController.this.tableAditionalFieldDetails.getSelectionModel().getSelectedItem();
            }
        });
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        if (this.selectedAditionalField != null && this.selectedAditionalFieldDetails != null) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("AditionalField", this.tableAditionalFields.getSelectionModel().getSelectedItem());
            this.parameters.put("AditionalFieldDetails", this.tableAditionalFieldDetails.getSelectionModel().getSelectedItem());
            ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
        } else {
            this.controller.alert("Obave\u0161tenje", "Morate selektovati dodatno polje kao i naziv detalja", this.rootPane.getScene().getWindow());
        }
    }

    private void populateTable() {
        ObservableList<AditionalField> listAditionalFields = AditionalField.getList(this.controller.getSettings().getConnection());
        boolean exist = false;
        for (AditionalField aditionalField : listAditionalFields) {
            exist = false;
            for (int i = 0; i < this.product.getListAditionalFieldDetailsProduct().size(); ++i) {
                if (((AditionalFieldDetailsProduct)this.product.getListAditionalFieldDetailsProduct().get(i)).getAditionalFieldID() != aditionalField.getAditionalFieldID()) continue;
                exist = true;
            }
            if (exist) continue;
            this.tableAditionalFields.getItems().add((Object)aditionalField);
        }
        if (this.tableAditionalFields.getItems().size() > 0) {
            this.tableAditionalFields.getSelectionModel().select(0);
            this.loadAditionalFieldDetails();
        }
    }

    private void loadAditionalFieldDetails() {
        try {
            this.tableAditionalFieldDetails.setItems(AditionalFieldDetails.getListByAditionalFieldID(((AditionalField)this.tableAditionalFields.getSelectionModel().getSelectedItem()).getAditionalFieldID(), this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("AditionalField", this.tableAditionalFields.getSelectionModel().getSelectedItem());
            this.parameters.put("AditionalFieldDetails", this.tableAditionalFieldDetails.getSelectionModel().getSelectedItem());
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

