/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import org.json.JSONException;
import org.json.JSONObject;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.controller.trgovina.TmasterExit;
import rs.petcom.master.dal.Licenca;
import rs.petcom.master.dal.LicencaResponse;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.MasterDbRefresh;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.WorkDayClosing;
import rs.petcom.master.licence.LicControl;
import rs.petcom.master.licence.LicLogic;
import rs.petcom.master.licence.exception.LicenseNotValid;
import rs.petcom.master.licence.exception.MacAddressReadException;
import rs.petcom.master.newFiscalization.status.LPFRStatus;
import rs.petcom.master.newFiscalization.tax.TaxRateSynchronization;
import rs.petcom.renameconnection.ChangeConnection;

public class LoginController
implements ControlledScreen {
    private static final Logger LOGGER = Logger.getLogger("global");
    WorkDay wd;
    String pib;
    private boolean workDay24h;
    EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case ENTER: {
                    LoginController.this.commitCode(null);
                    break;
                }
                case N: {
                    LoginController.this.toggleNumeric();
                    break;
                }
                case BACK_SPACE: {
                    if (LoginController.this.password.getText().length() <= 0) break;
                    String text = LoginController.this.password.getText().substring(0, LoginController.this.password.getText().length() - 1);
                    LoginController.this.password.setText(text);
                    break;
                }
                case DELETE: {
                    if (LoginController.this.password.getText().length() <= 0) break;
                    String text = LoginController.this.password.getText().substring(0, LoginController.this.password.getText().length() - 1);
                    LoginController.this.password.setText(text);
                    break;
                }
                default: {
                    if (!event.getCode().isDigitKey() || LoginController.this.password.isFocused()) break;
                    String text = LoginController.this.password.getText().concat(event.getText());
                    LoginController.this.password.setText(text);
                }
            }
        }
    };
    @FXML
    private AnchorPane rootPane;
    @FXML
    private AnchorPane borderPane;
    @FXML
    private AnchorPane logoBorderPane;
    @FXML
    private HBox hVBox;
    @FXML
    private GridPane mainGrid;
    @FXML
    private GridPane logoGridPane;
    @FXML
    private ImageView logoImage;
    @FXML
    private GridPane numericPane;
    @FXML
    private PasswordField password;
    @FXML
    private Button button0;
    @FXML
    private Button button1;
    @FXML
    private Button button2;
    @FXML
    private Button button3;
    @FXML
    private Button button4;
    @FXML
    private Button button5;
    @FXML
    private Button button6;
    @FXML
    private Button button7;
    @FXML
    private Button button8;
    @FXML
    private Button button9;
    @FXML
    private Button buttonEnter;
    @FXML
    private Button buttonDelete;
    @FXML
    private Button buttonPrijava;
    @FXML
    private ImageView imageView;
    @FXML
    private Label labelClock;
    @FXML
    private Label labelDate;
    @FXML
    private Label lblContact;
    private ScreensController controller;
    final SimpleDateFormat formatClock = new SimpleDateFormat("HH:mm:ss");
    final SimpleDateFormat formatDate = new SimpleDateFormat("EEEEEEEEE, d MMM yyyy");
    final Timeline timerSat = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            try {
                if (LoginController.this.labelClock != null && LoginController.this.labelDate != null) {
                    LoginController.this.labelClock.setText(LoginController.this.formatClock.format(new Date()));
                    LoginController.this.labelDate.setText(LoginController.this.formatDate.format(new Date()));
                }
            }
            catch (Exception e) {
                System.out.println("Problem sa datumom i satom");
            }
        }
    }, new KeyValue[0])});
    protected ObservableList<User> listActive;

    public LoginController() {
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
    }

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        this.workDay24h = Boolean.parseBoolean(this.controller.getSettings().getActualByName("24h.radno.vreme"));
    }

    @Override
    public void setParameter(java.lang.Object parameter) {
    }

    @Override
    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.password.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    LoginController.this.password.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
    }

    @Override
    public void init() {
        new MasterDbRefresh(this.controller);
        this.password.setText("");
        this.controller.getRoot().removeEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        this.controller.getRoot().addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        this.rootPane = new AnchorPane();
        this.rootPane.setPrefWidth(-1.0);
        this.rootPane.setPrefHeight(-1.0);
        Scene scene = new Scene((Parent)this.rootPane, 1020.0, 673.0);
        ImageView imageView = new ImageView();
        imageView.fitWidthProperty().bind((ObservableValue)scene.widthProperty().multiply(0.7));
        imageView.fitHeightProperty().bind((ObservableValue)scene.heightProperty());
        imageView.setPreserveRatio(true);
        this.rootPane.getChildren().add((java.lang.Object)imageView);
        File f = null;
        try {
            f = new File(this.controller.getSettings().getPozadina());
            this.rootPane.setStyle("-fx-background-image: url(" + f.toURI().toString() + ");-fx-background-size: cover,auto;");
        }
        catch (NullPointerException e) {
            e.getMessage();
        }
    }

    @FXML
    private void commitCode(ActionEvent event) {
        if (this.password.getText().length() > 0) {
            LPFRStatus lpfrStatus = new LPFRStatus(this.controller);
            String lpfrOK = lpfrStatus.checkStatus(this.rootPane.getScene().getWindow());
            if (lpfrOK != null && lpfrOK.isEmpty()) {
                this.controller.getSettings().setConnection(ChangeConnection.getConnectionAdmin(this.controller));
                TaxRateSynchronization synchronization = new TaxRateSynchronization(this.controller, this.controller.getUser());
                synchronization.synchronizeRates(this.rootPane.getScene().getWindow());
                this.controller.getSettings().setConnection(ChangeConnection.getConnectionUser(this.controller));
            }
            boolean loginOK = false;
            switch (this.controller.getVrstaPrograma()) {
                case 0: {
                    this.controller.setUser(User.getFromDb(this.password.getText(), this.controller.getSettings().getConnection()));
                    if (this.controller.getUser() == null || !this.controller.getUser().isActive() || !this.controller.getUser().hasRole("backoffice")) break;
                    loginOK = true;
                    break;
                }
                case 2: {
                    this.controller.setUser(User.getFromDb(this.password.getText(), this.controller.getSettings().getConnection()));
                    if (this.controller.getUser() == null || !this.controller.getUser().isActive() || !this.controller.getUser().hasRole("cashbox")) break;
                    loginOK = true;
                    break;
                }
                case 4: {
                    String string = this.password.getText();
                    this.controller.getSettings();
                    this.controller.setUser(User.getFromDb(string, Settings.getPosCode(), this.controller.getSettings().getConnection()));
                    if (this.controller.getUser() == null || !this.controller.getUser().isActive() || !this.controller.getUser().getUPosActive(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection()).booleanValue()) break;
                    if (this.controller.getUser().hasRole("cashbox") || this.controller.getUser().hasRole("posadmin")) {
                        loginOK = true;
                    }
                }
                case 6: {
                    String string = this.password.getText();
                    this.controller.getSettings();
                    this.controller.setUser(User.getFromDb(string, Settings.getPosCode(), this.controller.getSettings().getConnection()));
                    if (this.controller.getUser() == null || !this.controller.getUser().isActive() || !this.controller.getUser().getUPosActive(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection()).booleanValue() || !this.controller.getUser().hasRole("cashbox") && !this.controller.getUser().hasRole("posadmin")) break;
                    loginOK = true;
                }
            }
            if (loginOK) {
                this.controller.getRoot().removeEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                switch (this.controller.getVrstaPrograma()) {
                    case 0: {
                        this.controller.getScreen(ScreensController.SCREEN_BACKOFFICE, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
                        break;
                    }
                    case 2: {
                        this.controller.getScreen(ScreensController.SCREEN_RESTAURANT_STOLOVI, this.controller.getRoot(), ScreensController.SCREEN_LOGIN);
                    }
                    case 4: {
                        this.wd = WorkDay.getFromDb(this.controller.getPointOfSale(), this.controller.getSettings().getConnection());
                        if (this.controller.getUser().hasRole("cashbox")) {
                            LocalTime time1 = LocalTime.of(0, 1, 0);
                            Date date = new Date();
                            if (this.wd != null) {
                                Date wrkd = this.wd.getDateFrom();
                                LocalDate dateWd = wrkd.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                                if (this.wd != null && dateWd.isBefore(LocalDate.now()) && this.wd.getDateTo() == null && time1.getHour() > 13) {
                                    WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
                                }
                            }
                            if (this.wd == null) {
                                WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
                            } else {
                                int result = ScreensController.MODAL_RESULT_CANCEL;
                                if (this.wd.getDateTo() != null) {
                                    while (result == ScreensController.MODAL_RESULT_CANCEL) {
                                        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                                        hm.put("title", "Radni dan je zatvoren.");
                                        hm.put("text", "\nDa li \u017eelite da otvorite novi dan? \n\n *Ukoliko izaberete Ne nastavi\u0107e se unos za " + Settings.getDateFromatter().format(this.wd.getDate()) + "\n\n");
                                        result = this.controller.showModalDialog("Otvaranje radnog dana", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                                        if (result == ScreensController.MODAL_RESULT_YES) {
                                            if (this.workDay24h) {
                                                WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
                                                continue;
                                            }
                                            WorkDayClosing wdc = new WorkDayClosing(this.controller, this.wd);
                                            wdc.checkClosedDays();
                                            continue;
                                        }
                                        if (result != ScreensController.MODAL_RESULT_NO) continue;
                                        this.controller.setAuthorizationRequest(3);
                                        HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                                        hm2.put("controller", this.controller);
                                        int mr = this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm2, this.rootPane.getScene().getWindow());
                                        if (mr == ScreensController.MODAL_RESULT_OK) {
                                            try {
                                                this.wd.reopen(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection());
                                            }
                                            catch (SQLException e) {
                                                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                                                System.exit(0);
                                            }
                                            continue;
                                        }
                                        result = ScreensController.MODAL_RESULT_CANCEL;
                                    }
                                }
                                this.licencaNewCheck();
                                this.scheduleDailyTask();
                            }
                            LOGGER.info("Uspe\u0161an login. Korisnik: " + this.controller.getUser().getUserName());
                            this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
                        } else if (this.controller.getUser().hasRole("admin")) {
                            this.controller.getScreen(ScreensController.SCREEN_BACKOFFICE_MASTER, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
                        }
                        this.controller.getRoot().removeEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                        this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_LOGIN);
                        break;
                    }
                    case 6: {
                        this.wd = WorkDay.getFromDb(this.controller.getPointOfSale(), this.controller.getSettings().getConnection());
                        if (this.controller.getUser().hasRole("cashbox")) {
                            if (this.wd == null) {
                                WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
                            } else {
                                int result = ScreensController.MODAL_RESULT_CANCEL;
                                if (this.wd.getDateTo() != null) {
                                    while (result == ScreensController.MODAL_RESULT_CANCEL) {
                                        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                                        hm.put("title", "Radni dan je zatvoren.");
                                        hm.put("text", "\nDa li \u017eelite da otvorite novi dan? \n\n *Ukoliko izaberete Ne nastavi\u0107e se unos za " + Settings.getDateFromatter().format(this.wd.getDate()) + "\n\n");
                                        result = this.controller.showModalDialog("Otvaranje radnog dana", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                                        if (result == ScreensController.MODAL_RESULT_YES) {
                                            WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
                                            continue;
                                        }
                                        if (result != ScreensController.MODAL_RESULT_NO) continue;
                                        this.controller.setAuthorizationRequest(3);
                                        HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                                        hm2.put("controller", this.controller);
                                        int mr = this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm2, this.rootPane.getScene().getWindow());
                                        if (mr == ScreensController.MODAL_RESULT_OK) {
                                            try {
                                                this.wd.reopen(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection());
                                            }
                                            catch (SQLException e) {
                                                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                                                System.exit(0);
                                            }
                                            continue;
                                        }
                                        result = ScreensController.MODAL_RESULT_CANCEL;
                                    }
                                }
                                this.licCheck();
                            }
                            LOGGER.info("Uspe\u0161an login. Korisnik: " + this.controller.getUser().getUserName());
                            this.controller.getScreen(ScreensController.SCREEN_PEKARA, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
                        } else if (this.controller.getUser().hasRole("admin")) {
                            this.controller.getScreen(ScreensController.SCREEN_BACKOFFICE_MASTER, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
                        }
                        this.controller.getRoot().removeEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
                        this.controller.getScreen(ScreensController.SCREEN_PEKARA, this.controller.getRoot(), ScreensController.SCREEN_LOGIN);
                    }
                }
            } else {
                this.password.setText("");
                this.controller.setDialogTitle("alert.greskaPrilikomprijave.title");
                this.controller.setDialogText("alert.greskaPrilikomprijave.text");
                String[] buttons = new String[]{"OK"};
                this.controller.setDialogButtonText(buttons);
                this.controller.getScreen(ScreensController.SCREEN_ALLERT, this.controller.getRoot(), ScreensController.SCREEN_LOGIN_TRGOVINA);
            }
        }
    }

    public void scheduleDailyTask() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                System.out.println("Pozadinski proces je pokrenut.");
                String zd = LoginController.this.controller.getSettings().getActualByName("zd.automatski");
                if (zd != null && !zd.isEmpty() && Boolean.parseBoolean(zd)) {
                    WorkDay workDay = new WorkDay();
                    try {
                        ESCPosPrint posPrint = new ESCPosPrint(LoginController.this.controller, WorkDay.getLastOpenWD(LoginController.this.controller), WorkDay.getLastOpenWD(LoginController.this.controller));
                        posPrint.printCurrentSales("crossSection");
                        ESCPosPrint posPrint1 = new ESCPosPrint(LoginController.this.controller, WorkDay.getLastOpenWD(LoginController.this.controller), WorkDay.getLastOpenWD(LoginController.this.controller));
                        posPrint1.printCurrentSales("dnevni");
                        workDay.closeWorkDay(LoginController.this.controller.getUser(), LoginController.this.controller.getPointOfSale(), LoginController.this.controller.getSettings().getConnection());
                        if (LoginController.this.controller.getUser() != null) {
                            WorkDay.openWorkDay(LoginController.this.controller.getPointOfSale().getPointOfSaleID(), LoginController.this.controller.getUser().getUserID(), LoginController.this.controller.getSettings().getConnection());
                        } else {
                            WorkDay.openWorkDay(LoginController.this.controller.getPointOfSale().getPointOfSaleID(), 1L, LoginController.this.controller.getSettings().getConnection());
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        String vreme = this.controller.getSettings().getActualByLike("zd.automatski.vreme");
        Timer timer = new Timer();
        String[] sat = vreme.split(":");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, Integer.parseInt(sat[0]));
        calendar.set(12, Integer.parseInt(sat[1]));
        calendar.set(13, Integer.parseInt(sat[2]));
        calendar.set(14, 0);
        Date time = calendar.getTime();
        if (time.before(new Date())) {
            calendar.add(5, 1);
            time = calendar.getTime();
        }
        long period = 86400000L;
        timer.scheduleAtFixedRate(task, time, period);
    }

    private String uniqueId() {
        try {
            String command = "wmic csproduct get UUID";
            StringBuffer output = new StringBuffer();
            Process SerNumProcess = Runtime.getRuntime().exec(command);
            BufferedReader sNumReader = new BufferedReader(new InputStreamReader(SerNumProcess.getInputStream()));
            String line = "";
            while ((line = sNumReader.readLine()) != null) {
                output.append(line + "\n");
            }
            String machineID = output.toString().substring(output.indexOf("\n"), output.length()).trim();
            System.out.println(machineID);
            return machineID;
        }
        catch (Exception e) {
            LOGGER.warning("Problem kod UNIQUE ID " + e.getMessage());
            return "";
        }
    }

    private void licencaNewCheck() {
        TmasterExit tmasterExit = new TmasterExit(true);
        tmasterExit.start();
        if (LoginController.netIsAvailable()) {
            LOGGER.info("Provera licence");
            Object objects = Object.get(this.controller.getSettings().getConnection());
            String uniqueId = this.uniqueId();
            Licenca licenca = new Licenca(objects.getPIB(), uniqueId + "-" + objects.getPIB());
            String isExist = this.call(licenca);
            if ("true".equals(isExist)) {
                LocalDateTime localDateTime = LocalDateTime.now();
                ZonedDateTime zdt = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                long date = zdt.toInstant().toEpochMilli();
                String localDate = String.valueOf(date);
                CompanyConfig.updateCompanyConfig(localDate, this.controller);
            } else if ("false".equals(isExist)) {
                Platform.exit();
            } else if ("none".equals(isExist)) {
                this.isCheck();
            }
        } else {
            this.isCheck();
        }
    }

    private void isCheck() {
        ObservableList<CompanyConfig> companyConfigs = CompanyConfig.getList(this.controller);
        CompanyConfig companyConfig = (CompanyConfig)companyConfigs.get(0);
        if (companyConfig.getDatum() == null) {
            this.controller.alert("Obavestenje", "LICENCA NIJE PRONADJENA", this.rootPane.getScene().getWindow());
            Platform.exit();
        }
        LocalDateTime date1 = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(companyConfig.getDatum())), ZoneId.systemDefault());
        System.out.println(date1);
        LocalDate localDate1 = date1.toLocalDate();
        if (companyConfig.getDatum() != null && localDate1.isBefore(LocalDate.now().minusDays(5L))) {
            this.controller.alert("Obavestenje", "LICENCA NIJE PRONADJENA", this.rootPane.getScene().getWindow());
            Platform.exit();
        }
    }

    private String call(Licenca licenca) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL("https://licence.mastersoftware.rs/api/licence/tmaster");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Host", "");
            urlConnection.setDoOutput(true);
            OutputStream os = urlConnection.getOutputStream();
            ObjectMapper mapper = new ObjectMapper();
            String map = mapper.writeValueAsString((java.lang.Object)licenca);
            os.write(map.getBytes("UTF-8"));
            os.flush();
            String responseLine = "";
            int code = urlConnection.getResponseCode();
            if (code == 200) {
                InputStream is = urlConnection.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                BufferedReader bfr = new BufferedReader(isr);
                while ((responseLine = bfr.readLine()) != null) {
                    sb.append(responseLine);
                }
                LicencaResponse licencaResponse = (LicencaResponse)mapper.readValue(sb.toString(), LicencaResponse.class);
                if (!licencaResponse.getLicence().booleanValue() && licencaResponse.getMessage() != null && !licencaResponse.getMessage().isEmpty()) {
                    LOGGER.warning("Licena je " + licencaResponse.getMessage());
                    this.controller.alert("Obavestenje", licencaResponse.getMessage(), this.rootPane.getScene().getWindow());
                    return "false";
                }
                if (licencaResponse.getLicence().booleanValue() && licencaResponse.getMessage() != null && !licencaResponse.getMessage().isEmpty()) {
                    this.controller.alert("Upozorenje!", "" + licencaResponse.getMessage() + " \n", this.controller.getRoot().getScene().getWindow());
                    return "true";
                }
                if (licencaResponse.getLicence().booleanValue() && licencaResponse.getMessage().isEmpty()) {
                    return "true";
                }
            } else {
                InputStream is = urlConnection.getErrorStream();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                BufferedReader bfr = new BufferedReader(isr);
                while ((responseLine = bfr.readLine()) != null) {
                    sb.append(responseLine);
                }
                return "none";
            }
            LOGGER.warning("PROBLEM SA SERVISOM!!!");
            return "none";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "none";
        }
    }

    @FXML
    private void handleButtonAction(ActionEvent event) {
        if (event.getSource() != this.buttonDelete) {
            this.password.setText(this.password.getText() + ((Button)event.getSource()).getText());
        } else {
            try {
                String code = this.password.getText().substring(0, this.password.getText().length() - 1);
                this.password.setText(code);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @FXML
    private void supprotClicked() {
    }

    @FXML
    private void toggleNumeric() {
        this.numericPane.setVisible(!this.numericPane.isVisible());
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
    }

    @FXML
    private void exitClick() {
        Platform.exit();
        System.exit(0);
    }

    private void licCheck() {
        block15: {
            Date lastZD = null;
            try {
                lastZD = this.wd.getDate();
            }
            catch (NullPointerException e) {
                WorkDay.openWorkDay(this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getUser().getUserID(), this.controller.getSettings().getConnection());
            }
            this.pib = this.controller.getObject().getPIB();
            this.licenceFromWEb();
            try {
                Date licExp = null;
                try {
                    licExp = LicControl.getLicenseValidity(this.pib, (byte)0);
                }
                catch (MacAddressReadException ex) {
                    ex.printStackTrace();
                    this.controller.alert("Obavestenje", "PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_OCITAVANJA_MAC_ADRESE", this.rootPane.getScene().getWindow());
                    Platform.exit();
                }
                try {
                    if (licExp.compareTo(lastZD) < 0) {
                        this.licInput(this.pib, (byte)0, lastZD);
                        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                        hm.put("controller", this.controller);
                        int rez = this.controller.showModalDialog("Licenca - obnova", ScreensController.SCREEN_LICENCE, hm, this.rootPane.getScene().getWindow());
                        if (rez == ScreensController.MODAL_RESULT_OK) {
                            this.licInput((String)hm.get("licence"), (byte)0, lastZD);
                            this.licCheck();
                        } else {
                            Platform.exit();
                        }
                        return;
                    }
                    int leftDays = this.daysBetween(Settings.fromLocalDate(LocalDate.now()), licExp);
                    if (leftDays >= 0 && leftDays < 8) {
                        this.licNotify(this.pib, (byte)0, lastZD, leftDays);
                    }
                }
                catch (NullPointerException e) {
                    HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                    hm.put("controller", this.controller);
                    int rez = this.controller.showModalDialog("Licenca - obnova", ScreensController.SCREEN_LICENCE, hm, this.rootPane.getScene().getWindow());
                    if (rez == ScreensController.MODAL_RESULT_OK) {
                        this.licInput((String)hm.get("licence"), (byte)0, lastZD);
                        this.licCheck();
                        break block15;
                    }
                    Platform.exit();
                }
            }
            catch (FileNotFoundException ex) {
                this.controller.alert("Obavestenje", "LICENCA NIJE PRONADJENA", this.rootPane.getScene().getWindow());
                Platform.exit();
            }
            catch (IOException ex) {
                this.controller.alert("Obavestenje", "LICENCA NIJE PRONADJENA", this.rootPane.getScene().getWindow());
                Platform.exit();
            }
            catch (LicenseNotValid ex) {
                this.controller.alert("Obavestenje", "NIJE VALIDNA LICENCA", this.rootPane.getScene().getWindow());
                Platform.exit();
            }
        }
    }

    private int daysBetween(Date from, Date to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument d1 cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument d2 cannot be null");
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(from);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(to);
        int days = 0;
        long t1 = c1.getTimeInMillis();
        long t2 = c2.getTimeInMillis();
        days = (int)((t2 + (long)c2.get(16) - (t1 + (long)c1.get(16))) / 1000L / 60L / 60L / 24L);
        return days;
    }

    private void licNotify(String in, byte cc, Date lastZD, int daysLeft) {
        int rez;
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("licDaysOff", daysLeft);
        int r = this.controller.showModalDialog("Licenca - obavestenje", ScreensController.SCREEN_LICENCE_WARNING, hm, this.rootPane.getScene().getWindow());
        if (r == ScreensController.MODAL_RESULT_OK && (rez = this.controller.showModalDialog("Licenca - obnova", ScreensController.SCREEN_LICENCE, hm, this.rootPane.getScene().getWindow())) == ScreensController.MODAL_RESULT_OK) {
            this.licInput((String)hm.get("licence"), (byte)0, lastZD);
            this.licCheck();
        }
    }

    private void licInput(String in, byte cc, Date lastZD) {
        LicControl.storeLicenseData(this.pib, cc, in);
    }

    public void licenceFromWEb() {
        try {
            String ctrlCode = LicLogic.getControlCode(this.controller.getObject().getPIB(), (byte)0);
            System.out.println(ctrlCode);
            JSONObject json = LoginController.readJsonFromUrl("http://licence.petcom.rs/preuzmilicencu.php?ZaKljuc=" + ctrlCode);
            for (int i = 0; i < 10; ++i) {
                int c;
                BufferedWriter bufwriter;
                if (json == null) continue;
                String licenca = json.getString("licenca");
                String licFolder = "./license";
                InputStreamReader fr = null;
                File licFold = new File(licFolder);
                if (!licFold.exists()) {
                    licFold.mkdir();
                }
                for (File file : new File(licFolder).listFiles()) {
                    if (file.isDirectory()) continue;
                    file.delete();
                }
                File f = new File(licFolder + File.separator + ctrlCode + ".lic");
                if (!f.canRead()) {
                    f.createNewFile();
                    try {
                        bufwriter = new BufferedWriter(new FileWriter(f));
                        if (licenca.trim().equals("nemakreiranihlicenca")) {
                            bufwriter.write("");
                        } else {
                            bufwriter.write(licenca);
                        }
                        bufwriter.close();
                    }
                    catch (Exception e) {
                        System.out.println("Error occured while attempting to write to file: " + e.getMessage());
                    }
                } else {
                    try {
                        bufwriter = new BufferedWriter(new FileWriter(f));
                        bufwriter.write(licenca);
                        bufwriter.close();
                    }
                    catch (Exception e) {
                        System.out.println("Error occured while attempting to write to file: " + e.getMessage());
                    }
                }
                if (f.exists()) {
                    fr = new FileReader(f);
                }
                while ((c = fr.read()) > -1) {
                    licenca = licenca + (char)c;
                }
                fr.close();
                System.out.println(i);
                break;
            }
        }
        catch (IOException | JSONException | MacAddressReadException e) {
            e.printStackTrace();
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static JSONObject readJsonFromUrl(String url) {
        JSONObject json = null;
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = LoginController.readAll(rd).replace("mycallback(", "").replace(");", "");
            json = new JSONObject(jsonText);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return json;
    }

    private static boolean netIsAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

