/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.company;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class CompanyConfig {
    private long companyConfigID;
    private String name;
    private int minWorkHours;
    private String imagePath;
    private long addressID;
    private String datum;
    private String licenca;

    public String getDatum() {
        return this.datum;
    }

    public void setDatum(String datum) {
        this.datum = datum;
    }

    public String getLicenca() {
        return this.licenca;
    }

    public void setLicenca(String licenca) {
        this.licenca = licenca;
    }

    public long getCompanyConfigID() {
        return this.companyConfigID;
    }

    public void setCompanyConfigID(long companyConfigID) {
        this.companyConfigID = companyConfigID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMinWorkHours() {
        return this.minWorkHours;
    }

    public void setMinWorkHours(int minWorkHours) {
        this.minWorkHours = minWorkHours;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public long getAddressID() {
        return this.addressID;
    }

    public void setAddressID(long addressID) {
        this.addressID = addressID;
    }

    public static CompanyConfig getByID(long companyID, ScreensController controller) {
        String query = "SELECT * FROM companyconfig cc WHERE cc.CompanyConfigID = ?";
        CompanyConfig companyConfig = new CompanyConfig();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, companyID);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            companyConfig.companyConfigID = rSet.getLong("CompanyConfigID");
            companyConfig.name = rSet.getString("Name");
            companyConfig.minWorkHours = rSet.getInt("MinWorkHours");
            companyConfig.imagePath = rSet.getString("ImagePath");
            companyConfig.addressID = rSet.getLong("AddressID");
            rSet.close();
        }
        catch (SQLException e) {
            return null;
        }
        return companyConfig;
    }

    public static ObservableList<CompanyConfig> getList(ScreensController controller) {
        String query = "SELECT * FROM companyconfig";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                CompanyConfig companyConfig = new CompanyConfig();
                companyConfig.companyConfigID = rSet.getLong("CompanyConfigID");
                companyConfig.name = rSet.getString("Name");
                companyConfig.minWorkHours = rSet.getInt("MinWorkHours");
                companyConfig.imagePath = rSet.getString("ImagePath");
                companyConfig.addressID = rSet.getLong("AddressID");
                companyConfig.datum = rSet.getString("datum");
                list.add((Object)companyConfig);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void update(ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("UPDATE companyconfig SET  \t\t`Name` = ?,\t\t`AddressID` = ?");
            ps.setString(1, this.name);
            ps.setLong(2, this.addressID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateCompanyConfig(String date, ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("UPDATE companyconfig SET  \t\tdatum = ?");
            ps.setString(1, date);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `companyconfig` (`Name`, `AddressID`) VALUES (?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setLong(2, this.addressID);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

