/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.text.SimpleDateFormat;
import java.util.Date;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;

public class NarrowPosPrintHeader
extends ContentProporties {
    private SimpleDateFormat sdfPrint = new SimpleDateFormat("dd.MM.yyyy.");
    private Object objectDatas;
    private Address address;
    private Person person;
    private Date date;
    int printerNumOfCharacters;

    public NarrowPosPrintHeader(ScreensController controller, Printer printer, Document document) {
        this.objectDatas = controller.getObject();
        this.address = this.objectDatas.getAddress();
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.person = Person.getById(document.getPersonID(), controller);
        this.date = document.getDate();
    }

    public String makeHeader() {
        StringBuilder header = new StringBuilder();
        header.append(this.newRow());
        header.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(this.makeMultiRowContent(this.objectDatas.getName(), this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(this.makeMultiRowContent(this.address.getAddress(), this.printerNumOfCharacters));
        header.append(this.newRow());
        header.append(" PIB:");
        header.append(this.objectDatas.getPIB());
        header.append(this.newRow());
        header.append(" MB:");
        header.append(this.objectDatas.getMB());
        header.append(this.newRow());
        header.append(this.makeLineWithChar('=', this.printerNumOfCharacters));
        header.append(this.newRow());
        return header.toString();
    }

    public String makeBuyer() {
        StringBuilder buyer = new StringBuilder();
        buyer.append(" Kupac:");
        buyer.append(this.newRow());
        buyer.append(this.makeMultiRowContent(this.person.getName(), this.printerNumOfCharacters));
        buyer.append(this.newRow());
        buyer.append(this.makeMultiRowContent(this.person.getAddress(), this.printerNumOfCharacters));
        buyer.append(this.newRow());
        buyer.append(" PIB:");
        buyer.append(this.person.getPIB());
        buyer.append(this.newRow());
        buyer.append(" MB:");
        buyer.append(this.person.getMB());
        buyer.append(this.newRow());
        return buyer.toString();
    }

    public String posSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.newRow());
        signature.append(" Robu izdao");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" Robu primio:");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" Broj LK:");
        signature.append(this.newRow());
        signature.append(this.contentInTheMiddle(this.makeLineWithChar('.', this.printerNumOfCharacters - 5), this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.makeMultiRowContent("Mesto i datum prometa dobara i usluga:", this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(" " + this.address.getCity() + ", " + this.sdfPrint.format(this.date));
        signature.append(this.newRow());
        signature.append(this.makeLineWithChar('-', this.printerNumOfCharacters));
        signature.append(this.newRow());
        signature.append(this.newRow());
        signature.append(this.newRow());
        signature.append(this.newRow());
        return signature.toString();
    }
}

