/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.Style;
import java.io.IOException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.escpos.EscPosPrinterStandard;
import rs.petcom.master.PosPrint.escpos.IEscPosPrinter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.fical.Izvestaji;
import rs.petcom.master.newFiscalization.print.JasperStarter;
import rs.petcom.master.pdv.PdvDto;
import rs.petcom.master.utility.NPrintUtil;

public class NarrowPosPrintCurrentSales
extends ContentProporties {
    IEscPosPrinter escPosPrinter;
    private EscPos escPos;
    private Connection connection;
    private Style style;
    private int printerNumOfCharacters;
    private rs.petcom.master.dal.Object ob;
    private Address address;
    private WorkDay fromWd;
    private WorkDay toWd;
    private boolean inoiceA4;
    private ScreensController screensController;
    String path = ScreensController.SCREEN_JASPER_PRESEK_PERIODIICNI;

    public NarrowPosPrintCurrentSales(EscPos escPos, ScreensController controller, Printer printer, WorkDay fromWd, WorkDay toWd) {
        this.screensController = controller;
        this.escPos = escPos;
        this.fromWd = fromWd;
        this.toWd = toWd;
        this.connection = controller.getSettings().getConnection();
        this.style = new Style().setFontSize(Style.FontSize._1, Style.FontSize._2);
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.escPosPrinter = new EscPosPrinterStandard(escPos, printer.getServerName());
        this.ob = controller.getObject();
        this.address = Address.getByID(this.ob.getAddressID(), this.connection);
        this.inoiceA4 = Boolean.parseBoolean(controller.getSettings().getActualByName("print.A4"));
    }

    private void makeContent(String type, String posCode) throws IOException {
        String val;
        Date date = this.fromWd.getDate();
        String reportDate = Settings.getDateFromatter().format(date);
        String header = "PRESEK STANJA";
        if (type.equals("endDay")) {
            header = "KRAJ DANA";
        }
        if (type.equals("period")) {
            header = "PERIODICNI";
            reportDate = Settings.getDateFromatter().format(this.fromWd.getDate()) + "-" + Settings.getDateFromatter().format(this.toWd.getDate());
        }
        if (type.equals("dnevni")) {
            header = "DNEVNI IZVE\u0160TAJ";
            reportDate = Settings.getDateFromatter().format(this.fromWd.getDate()) + "-" + Settings.getDateFromatter().format(this.toWd.getDate());
        }
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        Izvestaji.differentCurrentSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID());
        Map<String, Double> currentSale = Izvestaji.currentSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID(), Integer.parseInt(posCode));
        Map<String, Double> rateSale = Izvestaji.vatRateSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID(), Integer.parseInt(posCode));
        String vatCode = this.vatCode(rateSale);
        Map<String, Double> ratePdv = Izvestaji.vatRatePdv(this.connection, vatCode);
        Map<String, PdvDto> cacalculatePdvAndBasics = this.calculatePdvAndBasics(ratePdv, rateSale);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeMultiRowContent("PIB:" + this.ob.getPIB(), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeMultiRowContent(this.ob.getName(), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeMultiRowContent(this.address.getAddress(), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeMultiRowContent(this.address.getCity(), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle(header + " " + reportDate, this.printerNumOfCharacters), this.style);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween1("Gotovina:", decimalFormat.format(currentSale.get("Gotovina")), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween1("Kartica:", decimalFormat.format(currentSale.get("Platna Kartica")), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Cek:", decimalFormat.format(currentSale.get("\u010cek")), this.printerNumOfCharacters));
        Double value = currentSale.get("Prenos na ra\u010dun") != null ? currentSale.get("Prenos na ra\u010dun") : currentSale.get("Faktura");
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Faktura:", decimalFormat.format(value), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Vau\u010der:", decimalFormat.format(currentSale.get("Vau\u010der")), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Instant placanje:", decimalFormat.format(currentSale.get("Instant pla\u0107anje")), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.textWithSpaceBetween("Ostalo:", decimalFormat.format(currentSale.get("Ostalo")), this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatinWithStyle(this.textWithSpaceBetween("Ukupno:", decimalFormat.format(currentSale.get("Ukupno")), this.printerNumOfCharacters), this.style);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        for (Map.Entry<String, Double> entry : rateSale.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            this.escPosPrinter.printLineCyrillic(this.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), this.printerNumOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin("Osnovice po stopama ");
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        for (Map.Entry<String, Object> entry : cacalculatePdvAndBasics.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            this.escPosPrinter.printLineCyrillic(this.textWithSpaceBetween(val, decimalFormat.format(((PdvDto)entry.getValue()).getBasics()), this.printerNumOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatin("Pdv po stopama ");
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        for (Map.Entry<String, Object> entry : cacalculatePdvAndBasics.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            this.escPosPrinter.printLineCyrillic(this.textWithSpaceBetween(val, decimalFormat.format(((PdvDto)entry.getValue()).getPdv()), this.printerNumOfCharacters));
        }
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
    }

    private StringBuilder makeContent1(String type, String posCode) throws IOException {
        String val;
        Date date = this.fromWd.getDate();
        String reportDate = Settings.getDateFromatter().format(date);
        String header = "PRESEK STANJA";
        if (type.equals("endDay")) {
            header = "KRAJ DANA";
        }
        if (type.equals("period")) {
            header = "PERIODICNI";
            reportDate = Settings.getDateFromatter().format(this.fromWd.getDate()) + "-" + Settings.getDateFromatter().format(this.toWd.getDate());
        }
        if (type.equals("dnevni")) {
            header = "DNEVNI IZVE\u0160TAJ";
            reportDate = Settings.getDateFromatter().format(this.fromWd.getDate()) + "-" + Settings.getDateFromatter().format(this.toWd.getDate());
        }
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        Izvestaji.differentCurrentSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID());
        Map<String, Double> currentSale = Izvestaji.currentSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID(), Integer.parseInt(posCode));
        Map<String, Double> rateSale = Izvestaji.vatRateSale(this.connection, this.fromWd.getWorkDayID(), this.toWd.getWorkDayID(), Integer.parseInt(posCode));
        String vatCode = this.vatCode(rateSale);
        Map<String, Double> ratePdv = Izvestaji.vatRatePdv(this.connection, vatCode);
        Map<String, PdvDto> cacalculatePdvAndBasics = this.calculatePdvAndBasics(ratePdv, rateSale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeMultiRowContent("PIB:" + this.ob.getPIB(), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeMultiRowContent(this.ob.getName(), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeMultiRowContent(this.address.getAddress(), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeMultiRowContent(this.address.getCity(), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.contentInTheMiddle(header + " " + reportDate, this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Gotovina:", decimalFormat.format(currentSale.get("Gotovina")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Kartica:", decimalFormat.format(currentSale.get("Platna Kartica")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Cek:", decimalFormat.format(currentSale.get("\u010cek")), this.printerNumOfCharacters) + "\n");
        Double value = currentSale.get("Prenos na ra\u010dun") != null ? currentSale.get("Prenos na ra\u010dun") : currentSale.get("Faktura");
        try {
            stringBuilder.append(this.textWithSpaceBetween("Faktura:", decimalFormat.format(value), this.printerNumOfCharacters) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append(this.textWithSpaceBetween("Vau\u010der:", decimalFormat.format(currentSale.get("Vau\u010der")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Instant placanje:", decimalFormat.format(currentSale.get("Instant pla\u0107anje")), this.printerNumOfCharacters) + "\n");
        try {
            stringBuilder.append(this.textWithSpaceBetween("Ostalo:", decimalFormat.format(currentSale.get("Ostalo")), this.printerNumOfCharacters) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("Ukupno:", decimalFormat.format(currentSale.get("Ukupno")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        for (Map.Entry<String, Double> entry : rateSale.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(this.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), this.printerNumOfCharacters) + "\n");
        }
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append("Osnovice po stopama \n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        for (Map.Entry<String, Object> entry : cacalculatePdvAndBasics.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(this.textWithSpaceBetween(val, decimalFormat.format(((PdvDto)entry.getValue()).getBasics()), this.printerNumOfCharacters) + "\n");
        }
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append("Pdv po stopama \n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        for (Map.Entry<String, Object> entry : cacalculatePdvAndBasics.entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(this.textWithSpaceBetween(val, decimalFormat.format(((PdvDto)entry.getValue()).getPdv()), this.printerNumOfCharacters) + "\n");
        }
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("*Avans uplaceno :", decimalFormat.format(currentSale.get("Avans")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("*Predracun uplaceno :", decimalFormat.format(currentSale.get("Predracun")), this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithString("=", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.textWithSpaceBetween("*Refundacija :", decimalFormat.format(currentSale.get("Refundacija")), this.printerNumOfCharacters) + "\n");
        return stringBuilder;
    }

    private String vatCode(Map<String, Double> rateSale) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Double> entry : rateSale.entrySet()) {
            stringBuilder.append(entry.getKey() + ",");
        }
        if (stringBuilder.toString().length() >= 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private Map<String, PdvDto> calculatePdvAndBasics(Map<String, Double> ratePdv, Map<String, Double> rateSale) {
        HashedMap pdvDtoMap = new HashedMap();
        for (Map.Entry<String, Double> entry : ratePdv.entrySet()) {
            PdvDto pdvDto = new PdvDto();
            pdvDto.setPdv(entry.getValue() * rateSale.get(entry.getKey()));
            pdvDto.setBasics(rateSale.get(entry.getKey()) - pdvDto.getPdv());
            pdvDtoMap.putIfAbsent(entry.getKey(), pdvDto);
        }
        return pdvDtoMap;
    }

    public void printContent(String type, String posCode, String stampa) throws IOException {
        if (!"true".equals(stampa) || this.escPosPrinter.getPrinterServerName().toUpperCase().contains("EPSON")) {
            this.makeContent(type, posCode);
            this.escPosPrinter.printBlankLines(5);
            this.escPos.cut(EscPos.CutMode.FULL);
            this.escPos.close();
        } else if (this.inoiceA4) {
            String header = "PRESEK STANJA";
            if (type.equals("endDay")) {
                header = "KRAJ DANA";
            }
            if (type.equals("period")) {
                header = "PERIODICNI";
            }
            if (type.equals("dnevni")) {
                header = "DNEVNI IZVE\u0160TAJ";
            }
            HashMap<String, Object> reportResources = new HashMap<String, Object>();
            reportResources.put("typeBill", header + "\n" + this.makeContent1(type, posCode));
            reportResources.put("controller", this.screensController);
            JasperStarter starter = new JasperStarter(reportResources, this.path, this.screensController.getRoot().getScene().getWindow());
            starter.createReportCollectionDataSource(this.screensController.getRoot().getScene().getWindow());
        } else {
            StringBuilder sales = this.makeContent1(type, posCode);
            this.escPosPrinter.printImage(sales, null, this.printerNumOfCharacters, this.escPos, null, new StringBuilder());
            this.escPosPrinter.printBlankLines(5);
            this.escPos.cut(EscPos.CutMode.FULL);
            this.escPos.close();
        }
    }
}

