/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.Style;
import java.io.IOException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import rs.petcom.master.PosPrint.ContentProporties;
import rs.petcom.master.PosPrint.escpos.EscPosPrinterStandard;
import rs.petcom.master.PosPrint.escpos.IEscPosPrinter;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.fical.Izvestaji;

public class NarrowPosPrintArticleSales
extends ContentProporties {
    IEscPosPrinter escPosPrinter;
    private EscPos escPos;
    private Date lastOpenedWorkDay;
    private Date from;
    private Connection connection;
    private Style style;
    private int printerNumOfCharacters;

    public NarrowPosPrintArticleSales(EscPos escPos, ScreensController controller, Printer printer) {
        this.escPos = escPos;
        this.lastOpenedWorkDay = WorkDay.getLastOpenWD(controller).getDate();
        this.from = WorkDay.getLastOpenWD(controller).getDateFrom();
        this.connection = controller.getSettings().getConnection();
        this.style = new Style().setFontSize(Style.FontSize._1, Style.FontSize._2).setBold(true);
        this.printerNumOfCharacters = printer.getNumOfCharacters();
        this.escPosPrinter = new EscPosPrinterStandard(escPos, printer.getServerName());
    }

    private void makeContent() throws IOException {
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        String reportDate = Settings.getDateFromatter().format(this.from);
        String[] values = null;
        String name = "";
        String quantity = "";
        String value = "";
        Double sum = 0.0;
        Map<Long, String[]> currentSaleWithArticles = Izvestaji.currentSaleWithArticles(this.connection, this.lastOpenedWorkDay);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle("PROMET PO ARTIKLIMA", this.printerNumOfCharacters), this.style);
        this.escPosPrinter.printLineLatinWithStyle(this.contentInTheMiddle(reportDate, this.printerNumOfCharacters), this.style);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
        for (Map.Entry<Long, String[]> entry : currentSaleWithArticles.entrySet()) {
            values = entry.getValue();
            name = values[0];
            quantity = values[1].replace('.', ',');
            value = values[3].replace('.', ',');
            sum = sum + Double.parseDouble(values[2]);
            this.escPosPrinter.printLineLatinWithStyle(this.textWithSpaceBetween(name, quantity, this.printerNumOfCharacters), this.style);
            this.escPosPrinter.printLineLatinWithStyle(" " + value, this.style);
            this.escPosPrinter.printLineLatin(this.makeLineWithChar('-', this.printerNumOfCharacters));
        }
        String sumValue = decimalFormat.format(sum);
        this.escPosPrinter.printLineLatinWithStyle(this.textWithSpaceBetween(" Ukupno:", sumValue, this.printerNumOfCharacters), this.style);
        this.escPosPrinter.printLineLatin(this.makeLineWithChar('=', this.printerNumOfCharacters));
    }

    private StringBuilder makeContent1() throws IOException {
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        String reportDate = Settings.getDateFromatter().format(this.from);
        String[] values = null;
        String name = "";
        String quantity = "";
        String value = "";
        String price = "";
        Double sum = 0.0;
        Map<Long, String[]> currentSaleWithArticles = Izvestaji.currentSaleWithArticles(this.connection, this.lastOpenedWorkDay);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeLineWithChar('=', this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.contentInTheMiddle("PROMET PO ARTIKLIMA", this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.contentInTheMiddle(reportDate, this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithChar('=', this.printerNumOfCharacters) + "\n");
        for (Map.Entry<Long, String[]> entry : currentSaleWithArticles.entrySet()) {
            values = entry.getValue();
            name = values[0];
            price = values[2].replace('.', ',');
            quantity = values[1].replace('.', ',');
            String[] quantityTemp = quantity.split(",");
            if (quantityTemp[1].equals("0")) {
                quantity = quantityTemp[0];
            }
            value = values[3].replace('.', ',');
            sum = sum + Double.parseDouble(values[3]);
            StringBuilder stringBuilder1 = new StringBuilder();
            stringBuilder1.append(name.length() <= this.printerNumOfCharacters - 1 ? name : name.substring(0, this.printerNumOfCharacters - 1) + "\n");
            if (name.length() > this.printerNumOfCharacters - 1) {
                stringBuilder1.append(name.substring(this.printerNumOfCharacters - 1, name.length()) + "\n");
            }
            stringBuilder.append(stringBuilder1.toString() + "\n");
            String row = "  " + quantity + " X " + price;
            stringBuilder.append(this.textWithSpaceBetween(row, value, this.printerNumOfCharacters) + "\n\n");
            stringBuilder.append(this.makeLineWithChar('-', this.printerNumOfCharacters) + "\n");
        }
        String sumValue = decimalFormat.format(sum);
        stringBuilder.append(this.textWithSpaceBetween(" Ukupno:", sumValue, this.printerNumOfCharacters) + "\n");
        stringBuilder.append(this.makeLineWithChar('=', this.printerNumOfCharacters) + "\n");
        return stringBuilder;
    }

    public void printContent(String stampa) throws IOException {
        if (!"true".equals(stampa) || this.escPosPrinter.getPrinterServerName().toUpperCase().contains("EPSON")) {
            this.makeContent();
            this.escPosPrinter.printBlankLines(5);
            this.escPos.cut(EscPos.CutMode.FULL);
            this.escPos.close();
        } else {
            this.printerNumOfCharacters = this.printerNumOfCharacters < 40 ? 30 : 40;
            this.escPosPrinter.printImage(this.makeContent1(), null, this.printerNumOfCharacters, this.escPos, null, new StringBuilder());
            this.escPosPrinter.printBlankLines(5);
            this.escPos.cut(EscPos.CutMode.FULL);
            this.escPos.close();
        }
    }
}

