/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.PosPrint;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import rs.petcom.master.utility.NPrintUtil;

public class ContentProporties {
    protected String makeLineWithString(String string, int numOfCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfCharacters - 1; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public String taxMarkNameLineImage(String mark, String name, int numberChar) {
        int value = 15;
        if (numberChar <= 30) {
            value = 12;
        }
        return this.textWithSpaceBetween(mark, name, value);
    }

    public String taxRateVatLineImage(String rate, String vat, int numberChar) {
        int value = 14;
        if (numberChar <= 30) {
            value = 10;
        }
        int rLength = rate.length();
        return this.textWithSpaceBetween(rate, vat, rLength + value);
    }

    public String makeLineWithChar(char lineChar, int printerNumOfCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < printerNumOfCharacters - 1; ++i) {
            sb.append(lineChar);
        }
        return sb.toString();
    }

    public String contentInTheMiddle(String content, int printerNumOfCharacters) {
        int numOfChars = (printerNumOfCharacters - content.length()) / 2 + content.length() - 1;
        return String.format("%" + numOfChars + "s", content);
    }

    public String contentAtTheEnd(String content, int printerNumOfCharacters) {
        int numOfChars = printerNumOfCharacters - 2;
        return String.format("%" + numOfChars + "s", content);
    }

    public String makeMultiRowContent(String content, int printerNumOfCharacters) {
        StringBuilder multiContent = new StringBuilder();
        while (content.length() != 0) {
            if (content.length() > printerNumOfCharacters) {
                multiContent.append(" ");
                multiContent.append(content.substring(0, printerNumOfCharacters - 2));
                multiContent.append(this.newRow());
                content = content.substring(printerNumOfCharacters - 2);
                continue;
            }
            multiContent.append(" ");
            multiContent.append(content);
            content = "";
        }
        return multiContent.toString();
    }

    public String textInTheMiddleWithSigns(String text, char sign, int printerNumOfCharaxters) {
        int i;
        int rest = printerNumOfCharaxters - text.length();
        int before = rest / 2;
        int after = before++;
        if (rest % 2 != 0) {
            // empty if block
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < before; ++i) {
            result.append(sign);
        }
        result.append(text);
        for (i = 0; i < after; ++i) {
            result.append(sign);
        }
        return result.toString();
    }

    public String textWithSpaceBetween(String left, String right, int printerNumOfCharaxters) {
        int rest = printerNumOfCharaxters - left.length() - right.length();
        StringBuilder result = new StringBuilder();
        result.append(" ");
        result.append(left);
        for (int i = 0; i < rest - 2; ++i) {
            result.append(" ");
        }
        result.append(right);
        return result.toString();
    }

    public String textWithSpaceBetween1(String left, String right, int printerNumOfCharaxters) {
        int rest = printerNumOfCharaxters - left.length() - right.length();
        String result = "";
        result = result + " ";
        result = result + left;
        for (int i = 0; i < rest - 2; ++i) {
            result = result + " ";
        }
        result = result + right;
        return result;
    }

    public String qunatitySumLine(String quantity, String sum, int numberChar) {
        int qLength = quantity.length();
        return this.textWithSpaceBetween(quantity, sum, qLength + 15);
    }

    public String priceLine(String empty, String price) {
        return this.textWithSpaceBetween(empty, price, 14);
    }

    public String taxMarkNameLine(String mark, String name) {
        return this.textWithSpaceBetween(mark, name, 15);
    }

    public String taxRateVatLine(String rate, String vat) {
        int rLength = rate.length();
        return this.textWithSpaceBetween(rate, vat, rLength + 12);
    }

    public String formatOnThree(double value) {
        return NPrintUtil.decimalFormatOnThree(value);
    }

    public String formatOnTwo(double value) {
        return NPrintUtil.decimalFormatOnTwoWithZero(value);
    }

    public String methodName(String key) {
        if (key.toLowerCase().equals("cash")) {
            return "Gotovina:";
        }
        if (key.toLowerCase().equals("card")) {
            return "Platna Kartica:";
        }
        if (key.toLowerCase().equals("check")) {
            return "Cek:";
        }
        if (key.toLowerCase().equals("wiretransfer")) {
            return "Prenos na ra\u010dun:";
        }
        if (key.toLowerCase().equals("voucher")) {
            return "Vaucer:";
        }
        if (key.toLowerCase().equals("mobilemoney")) {
            return "Instant placanje:";
        }
        if (key.toLowerCase().equals("other")) {
            return "Drugo bezgotovinsko pla\u0107anje:";
        }
        return "";
    }

    public String newRow() {
        return "\n";
    }

    public String clearFromEasternLatinChars(String input) {
        input = input.replaceAll("\u010c", "C");
        input = input.replaceAll("\u010d", "c");
        input = input.replaceAll("\u0106", "C");
        input = input.replaceAll("\u0107", "c");
        input = input.replaceAll("\u0110", "Dj");
        input = input.replaceAll("\u0111", "dj");
        input = input.replaceAll("\u0160", "S");
        input = input.replaceAll("\u0161", "s");
        input = input.replaceAll("\u017d", "Z");
        input = input.replaceAll("\u017e", "z");
        return input;
    }

    public BufferedImage convertTextToGraphic(String text, Font font) {
        String[] lines = text.split("\n");
        File newFile = new File("./test.jpeg");
        FontRenderContext frc = new FontRenderContext(null, true, true);
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics2D g = image.createGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight() * lines.length;
        int w = fm.stringWidth(lines[0]);
        g.dispose();
        image = new BufferedImage(w, h, 1);
        g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.drawString(text, 0, -h);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, "jpg", newFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public String spaces(int spacesCount) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < spacesCount - 1; ++i) {
            result.append(" ");
        }
        return result.toString();
    }
}

