/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.Person;

public class DynamicJasperSample {
    public static void main(String[] args) throws Exception {
        DynamicJasperSample dynamicJasperSample = new DynamicJasperSample();
        JasperDesign design = dynamicJasperSample.createDesign();
        ArrayList<Person> personList = new ArrayList<Person>();
        for (Person p : Person.getListByCategory(true, Settings.getNewConnection("localhost", "masterdb"))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("firstName", p.getName());
            map.put("lastName", p.getLastName());
            map.put("PIB", p.getPIB());
            Person person = new Person(map);
            personList.add(person);
        }
        JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)design);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, new HashMap(), (JRDataSource)new JRBeanCollectionDataSource(personList));
        File pdf = null;
        try {
            File directory = new File(String.valueOf("./jasperReport"));
            if (!directory.exists()) {
                directory.mkdir();
            }
            pdf = File.createTempFile("jas", ".pdf", directory);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)new FileOutputStream(pdf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public JasperDesign createDesign() throws JRException {
        JasperDesign jasperDesign = new JasperDesign();
        jasperDesign.setName("sampleDynamicJasperDesign");
        jasperDesign.setPageWidth(595);
        jasperDesign.setPageHeight(842);
        jasperDesign.setColumnWidth(515);
        jasperDesign.setColumnSpacing(0);
        jasperDesign.setLeftMargin(40);
        jasperDesign.setRightMargin(40);
        jasperDesign.setTopMargin(20);
        jasperDesign.setBottomMargin(20);
        JRDesignExpression expression = new JRDesignExpression();
        JRDesignStyle normalStyle = new JRDesignStyle();
        normalStyle.setName("Sans_Normal");
        normalStyle.setDefault(true);
        normalStyle.setFontName("Arial");
        normalStyle.setFontSize(12);
        normalStyle.setPdfFontName("Helvetica");
        normalStyle.setPdfEncoding("UTF-8");
        normalStyle.setPdfEmbedded(false);
        jasperDesign.addStyle((JRStyle)normalStyle);
        JRDesignField field = new JRDesignField();
        field.setName("firstName");
        field.setValueClass(String.class);
        jasperDesign.addField((JRField)field);
        field = new JRDesignField();
        field.setName("lastName");
        field.setValueClass(String.class);
        jasperDesign.addField((JRField)field);
        field = new JRDesignField();
        field.setName("PIB");
        field.setValueClass(String.class);
        jasperDesign.addField((JRField)field);
        JRDesignBand band = new JRDesignBand();
        band = new JRDesignBand();
        band.setHeight(30);
        JRDesignStaticText staticText = new JRDesignStaticText();
        staticText.setText("Person's Specification");
        staticText.setX(0);
        staticText.setY(0);
        staticText.setHeight(20);
        staticText.setWidth(515);
        staticText.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
        band.addElement((JRDesignElement)staticText);
        jasperDesign.setTitle((JRBand)band);
        band = new JRDesignBand();
        band.setHeight(20);
        JRDesignTextField textField = new JRDesignTextField();
        textField.setX(0);
        textField.setY(0);
        textField.setWidth(160);
        textField.setHeight(20);
        JRDesignExpression jrExpression = new JRDesignExpression();
        jrExpression.setText("\"First Name: \"+$F{firstName}");
        textField.setExpression((JRExpression)jrExpression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setX(160);
        textField.setY(0);
        textField.setWidth(160);
        textField.setHeight(20);
        jrExpression = new JRDesignExpression();
        jrExpression.setText("$F{lastName}+\" :Last Name\"");
        textField.setExpression((JRExpression)jrExpression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setX(320);
        textField.setY(0);
        textField.setWidth(160);
        textField.setHeight(20);
        jrExpression = new JRDesignExpression();
        String PIB = "\"<html><font color=\\\"#66FF33\\\">\"+\"PIB is: \"+\"</font><font color=\\\"#6600FF\\\">\"+$F{PIB}+\"</font></html>\"";
        jrExpression.setText(PIB);
        textField.setExpression((JRExpression)jrExpression);
        textField.setMarkup("html");
        band.addElement((JRDesignElement)textField);
        ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)band);
        return jasperDesign;
    }
}

