/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;

public class DialogBundle {
    Stage stage;
    DialogController controller;
    Settings settings;

    public DialogBundle(String resource, ResourceBundle bundle, Settings settings) {
        this.settings = settings;
        this.stage = new Stage();
        this.stage.initModality(Modality.WINDOW_MODAL);
        try {
            BorderPane loadedScreen = null;
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(resource), bundle);
            loadedScreen = (BorderPane)fxmlLoader.load();
            this.controller = (DialogController)fxmlLoader.getController();
            this.controller.setModalResult(ScreensController.MODAL_RESULT_CANCEL);
            this.stage.setScene(new Scene((Parent)loadedScreen));
            this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    DialogBundle.this.controller.setModalResult(ScreensController.MODAL_RESULT_CANCEL);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public HashMap<String, Object> getParameters() {
        return this.controller.getParameter();
    }

    public void setParameters(HashMap<String, Object> parameters) {
        this.controller.setParameter(parameters);
    }

    public int getModalResult() {
        return this.controller.getModalResult();
    }

    public int showAndWait() {
        this.stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        this.stage.showAndWait();
        this.stage.hide();
        return this.controller.getModalResult();
    }

    public int showAndWaitWithoutFullScreen() {
        this.stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        this.stage.setMaximized(false);
        this.stage.showAndWait();
        this.stage.hide();
        return this.controller.getModalResult();
    }
}

