/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.enums;

public enum InvoiceType {
    AVANS("Avans", 36, "Advance", "FISKALNI RA\u010cUN", "AVANS-PRODAJA", "FISKALNI RA\u010cUN"),
    SALE_NORMAL("Ra\u010dun", 3, "Normal", "FISKALNI RA\u010cUN", "PROMET PRODAJA", "KRAJ FISKALNOG RA\u010cUNA"),
    SALE_COPY("Ra\u010dun-kopija", 31, "Copy", "OVO NIJE FISKALNI RA\u010cUN", "KOPIJA PRODAJA", "OVO NIJE FISKALNI RA\u010cUN"),
    SALE_PROFORMA("Predra\u010dun", 31, "Proforma", "OVO NIJE FISKALNI RA\u010cUN", "PREDRA\u010cUN PRODAJA", "OVO NIJE FISKALNI RA\u010cUN"),
    REFUND_NORMAL("Refundacija", 22, "Normal", "FISKALNI RA\u010cUN", "PROMET REFUNDACIJA", "KRAJ FISKALNOG RA\u010cUNA"),
    REFUND_COPY("Refundacija-kopija", 33, "Copy", "OVO NIJE FISKALNI RA\u010cUN", "KOPIJA REFUNDACIJA", "OVO NIJE FISKALNI RA\u010cUN"),
    REFUND_PROFORMA("Refundacija-predra\u010dun", 35, "Proforma", "OVO NIJE FISKALNI RA\u010cUN", "PREDRA\u010cUN REFUNDACIJA", "OVO NIJE FISKALNI RA\u010cUN"),
    REFUND_AVANS("Refundacija-avans", 37, "Advance", "FISKALNI RA\u010cUN", "AVANS-REFUNDACIJA", "FISKALNI RA\u010cUN"),
    SALE_TRAINING("Ra\u010dun-trening", 32, "Training", "OVO NIJE FISKALNI RA\u010cUN", "OBUKA PRODAJA", "OVO NIJE FISKALNI RA\u010cUN"),
    REFUND_TRAINING("Refundacija-trening", 34, "Training", "OVO NIJE FISKALNI RA\u010cUN", "OBUKA REFUNDACIJA", "OVO NIJE FISKALNI RA\u010cUN");

    String name;
    String type;
    String header;
    String headline;
    String footer;
    int typeId;

    private InvoiceType(String name, int typeId, String type, String header, String headLine, String footer) {
        this.name = name;
        this.typeId = typeId;
        this.type = type;
        this.header = header;
        this.headline = headLine;
        this.footer = footer;
    }

    public String getHeader() {
        return this.header;
    }

    public String getHeadline() {
        return this.headline;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public static InvoiceType getByName(String name) {
        switch (name.toLowerCase()) {
            case "ra\u010dun": {
                return SALE_NORMAL;
            }
            case "ra\u010dun-kopija": {
                return SALE_COPY;
            }
            case "refundacija": {
                return REFUND_NORMAL;
            }
            case "refundacija-kopija": {
                return REFUND_COPY;
            }
            case "ra\u010dun-trening": {
                return SALE_TRAINING;
            }
            case "refundacija-trening": {
                return REFUND_TRAINING;
            }
            case "refundacija-predra\u010dun": {
                return REFUND_PROFORMA;
            }
        }
        return SALE_NORMAL;
    }
}

