/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.email;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailAttachmentSender {
    public static void sendEmailWithAttachments(String host, String port, final String userName, final String password, String toAddress, String subject, String message, List<File> attachFiles) throws AddressException, MessagingException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        properties.put("mail.smtp.port", port);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.put("mail.user", userName);
        properties.put("mail.password", password);
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        };
        Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(userName));
        InternetAddress[] toAddresses = new InternetAddress[]{new InternetAddress(toAddress)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)message, "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (attachFiles != null && attachFiles.size() > 0) {
            for (File filePath : attachFiles) {
                MimeBodyPart attachPart = new MimeBodyPart();
                try {
                    attachPart.attachFile(filePath.getAbsolutePath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                multipart.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }
}

