/*
 * Decompiled with CFR 0.152.
 */
package functions.rfc.sap.document.sap_com.client;

import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_ITEMS_LINE;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_LINE;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_SERVICEProxy;
import functions.rfc.sap.document.sap_com.holders.ZRETAIL_SALE_ITEMS_TTHolder;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.rpc.holders.StringHolder;
import org.apache.axis.AxisFault;
import rs.petcom.master.dal.product.Product;

public class SaleClient {
    private static final Logger LOGGER = Logger.getLogger("global");
    StringBuilder sBuilder = new StringBuilder();

    public ZRETAIL_SALE_ITEMS_LINE[] getSaleResponseFromSAP(List<Product> entryList, StringHolder MESSAGE, StringHolder RECEIPT_DOCUMENT) {
        String endpoint = "http://kwsvk110.sap.kws.com:8033/sap/bc/srt/rfc/sap/zretail_sale_service/100/zretail_sale_service/100_binding";
        LOGGER.info("getSaleResponseFromSAP; endpoint:" + endpoint);
        StringHolder STATUS = new StringHolder();
        ZRETAIL_SALE_ITEMS_TTHolder SALE_ITEMS = new ZRETAIL_SALE_ITEMS_TTHolder();
        ZRETAIL_SALE_SERVICEProxy pr = new ZRETAIL_SALE_SERVICEProxy(endpoint);
        try {
            ZRETAIL_SALE_LINE[] RETAIL_DATA = this.generateSaleRequestForSAP(entryList);
            LOGGER.info("Pokusavamo prodaju ovih artikala: " + this.sBuilder.toString());
            pr.ZRETAIL_SALE(RETAIL_DATA, MESSAGE, RECEIPT_DOCUMENT, SALE_ITEMS, STATUS);
            if (!STATUS.value.equalsIgnoreCase("ok")) {
                return null;
            }
        }
        catch (RemoteException e) {
            AxisFault af = (AxisFault)e;
            this.sBuilder.append(af.getFaultActor() + "\r\n");
            this.sBuilder.append(af.getFaultCode());
            LOGGER.info("Neuspesna komunikacija sa SAPom. Error: " + this.sBuilder.toString());
        }
        LOGGER.info("USPESNA METODA getSaleResponseFromSAP");
        return SALE_ITEMS.value;
    }

    private ZRETAIL_SALE_LINE[] generateSaleRequestForSAP(List<Product> list) {
        LOGGER.info("Ulaz u metodu generateSaleRequestForSAPNOVI");
        this.sBuilder = new StringBuilder();
        int i = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<String, ZRETAIL_SALE_LINE> lineMap = new HashMap<String, ZRETAIL_SALE_LINE>();
        int itemNumber = 10;
        for (Product o : list) {
            ZRETAIL_SALE_LINE line = new ZRETAIL_SALE_LINE();
            String[] split = o.getName().split(":");
            String seria = "";
            if (split.length >= 2) {
                seria = SaleClient.getSeria(split[1]);
                LOGGER.info("\nSeria");
            }
            this.sBuilder.append("Name: " + o.getName());
            line.setITEM(o.getProductID() + "");
            this.sBuilder.append("productID: " + line.getITEM() + "\n");
            line.setEAN11(o.getCode());
            this.sBuilder.append("CODE: " + line.getEAN11() + "\n");
            line.setZZLICHA(seria);
            this.sBuilder.append("SERIA: " + seria);
            line.setQUANTITY(new BigDecimal(1));
            this.sBuilder.append("QUANTITY: " + line.getQUANTITY());
            line.setUOM("UN");
            this.sBuilder.append(line.getUOM() + "\n");
            String mapKey = line.getEAN11() + line.getZZLICHA();
            if (map.containsKey(mapKey)) {
                map.put(mapKey, (Integer)map.get(mapKey) + 1);
                this.sBuilder.append("\nAzuriramo mapu mapKey; nove vrednosti key-value: " + mapKey + " value: " + map.get(mapKey));
                continue;
            }
            lineMap.put(mapKey, line);
            this.sBuilder.append("\nAzuriramo mapu lineMap; nove vrednosti key-value: " + mapKey + " value: " + lineMap.get(mapKey));
            map.put(mapKey, 1);
            this.sBuilder.append("\nAzuriramo mapu mapKey; nove vrednosti key-value: " + mapKey + " value: " + map.get(mapKey));
        }
        int arraySize = lineMap.keySet().size();
        ZRETAIL_SALE_LINE[] RETAIL_DATA = new ZRETAIL_SALE_LINE[arraySize];
        LOGGER.info(this.sBuilder.toString());
        LOGGER.info("\nlineMapKeys: " + lineMap.keySet().toString());
        LOGGER.info("\nlineMapVals: " + lineMap.values().toString());
        LOGGER.info("\nmapKeys: " + lineMap.keySet().toString());
        LOGGER.info("\nmapVals: " + map.values().toString());
        for (String key : lineMap.keySet()) {
            ZRETAIL_SALE_LINE item = (ZRETAIL_SALE_LINE)lineMap.get(key);
            item.setITEM(itemNumber + "");
            itemNumber += 10;
            item.setQUANTITY(new BigDecimal((Integer)map.get(key)));
            RETAIL_DATA[i++] = item;
        }
        return RETAIL_DATA;
    }

    private static String getSeria(String input) {
        String seria = input;
        int kin = seria.indexOf("K");
        int min = seria.indexOf("-");
        seria = min == kin - 1 ? seria.substring(min - 4) : seria.substring(kin - 4);
        String result = seria;
        String s1 = "";
        String s2 = "";
        String s3 = "";
        if (!seria.contains("-")) {
            s1 = seria.substring(0, seria.indexOf(75));
            s2 = seria.substring(seria.indexOf(75), seria.indexOf(75) + 3);
            s3 = seria.substring(seria.indexOf(75) + 3);
            System.out.println(s1 + " " + s2 + " " + s3);
            result = s1 + "-" + s2 + "-" + s3;
        }
        return result;
    }

    public static void main(String[] args) {
        SaleClient.getSeria("222222222222222222220453KWS20");
        System.out.println(SaleClient.getSeria("222222222222222222220453KWS20"));
    }
}

