SELECT
    a.id AS artikal_id,
    a.name AS artikal_naziv,
    a.cena AS artikal_cena,
    cd.id AS id,
    (SELECT 
            zakljucenje
        FROM
            zd
        WHERE
            datum = ? AND pocetak = 1) AS datum,
    ROUND(COALESCE(c.prodajnaCena, a.cena), 2) AS prodajna_cena,
    COALESCE(SUM(ds.beloulaz - ds.beloizlaz), 0) AS kolicina,
    a.poreskaGrupa AS art_pg,
    a.jedinicaMere AS art_jed_mere,
    0 as tip
FROM
    artikal a
        LEFT JOIN
    cenovnikzadan cd ON cd.zadan = (SELECT 
            MIN(zaDan)
        FROM
            cenovnikzadan
        WHERE
            zadan >= ? AND zakljucen = TRUE)
        LEFT JOIN
    cenazadan c ON c.cenovnik_id = cd.id
        AND c.artikal_id = a.id
        LEFT JOIN
    dnevnostanje ds ON ds.artikalID = a.id AND ds.datum < ?
        AND ds.odeljenje_id <> 1
GROUP BY a.id 
UNION ALL SELECT 
    a.id,
    a.name,
    a.cena,
    cd.id,
    COALESCE((SELECT 
                    zakljucenje
                FROM
                    zd
                WHERE
                    datum = ? AND pocetak = 0),
            CURDATE()) AS datum,
    ROUND(COALESCE(c.prodajnaCena, a.cena), 2),
    0 AS kolicina,
    a.poreskaGrupa AS art_pg,
    a.jedinicaMere AS art_jed_mere,
    2 as tip
FROM
    artikal a
        LEFT JOIN
    cenovnikzadan cd ON cd.zadan = (SELECT 
            MIN(zaDan)
        FROM
            cenovnikzadan
        WHERE
            zadan > ? AND zakljucen = TRUE)
        LEFT JOIN
    cenazadan c ON c.cenovnik_id = cd.id
        AND c.artikal_id = a.id 
UNION ALL SELECT 
    a.id,
    a.name,
    a.cena,
    r.id,
    r.datum,
    COALESCE(ROUND(sr.cena * (100 - r.popust) / 100, 2),
            a.cena) AS cena_sa_popustom,
    SUM(sr.kolicina) * - 1.0 AS kolicina,
    a.poreskaGrupa AS art_pg,
    a.jedinicaMere AS art_jed_mere,
    1 as tip
FROM
    racun r
        INNER JOIN
    stavkaracuna sr ON r.id = sr.racun_id
        INNER JOIN
    artikal a ON sr.artikal_id = a.id
WHERE
    r.datum BETWEEN (SELECT 
            zakljucenje
        FROM
            zd
        WHERE
            datum = ? AND pocetak = 1) AND COALESCE((SELECT 
                    zakljucenje
                FROM
                    zd
                WHERE
                    datum = ? AND pocetak = 0),
            NOW())
GROUP BY a.id , cena_sa_popustom
ORDER BY artikal_id, tip, datum