set @date = str_to_date(?, '%Y-%m-%d'),
    @promena = 0,
    @cena = -1,
    @aid = -1,
    @kolicina = 0.0,
    @tkol = 0.0,
    @staracena = -1,
    @pdvstopa = 0,
    @stanje = 0,
    @povecanjeceneneto = 0,
    @povecanjepdv = 0,
    @rbr = 0;

select
    @rbr := @rbr + 1 as redni_broj,
    artikal_naziv,
    jedinica_mere,
    round(staro_stanje, 4) as kolicina,
    round(stara_cena_neto, 2) as stara_cena,
    round(nova_cena_neto, 2) as nova_cena,
    round(povecanje_cene_neto, 2) as povecanje_cene,
    round(pdv, 2) as pdv,
    round(povecanje_pdva, 2) as povecanje_pdva,
    round(stara_cena, 2) as stara_cena_sa_pdv,
    round(nova_cena, 2) as nova_cena_sa_pdv,
    round(povecanje_cene_neto * staro_stanje, 2) as povecanje_razlike_u_ceni,
    round(povecanje_pdva * staro_stanje, 2) as povecanje_poreza
  from (
    select
        bb.art_id,
        bb.art_naziv as artikal_naziv,
        bb.promena,
        bb.art_jed_mere as jedinica_mere,
        @pdvstopa := (
          CASE
            WHEN bb.art_pg = 3 THEN 0.2
            WHEN bb.art_pg = 4 THEN 0.1
            WHEN bb.art_pg = 0 THEN 0.0
            WHEN bb.art_pg = 1 THEN 0.0
            ELSE NULL
          END
        ) AS stopa,
        if(promena = 0, 0.0, @staracena) as stara_cena,
        if(promena = 0, 0.0, @staracena / (1.0 + @pdvstopa)) as stara_cena_neto,
        if(promena = 0, 0.0, bb.prod_cena / (1.0 + @pdvstopa)) as nova_cena_neto,
        if(promena = 0, 0.0, (bb.prod_cena - @staracena) / (1.0 + @pdvstopa)) as povecanje_cene_neto,
        if(promena = 0, 0.0, (bb.prod_cena) / (1.0 + @pdvstopa) * @pdvstopa) as pdv,
        @povecanjepdv := if(promena = 0, 0.0, (bb.prod_cena - @staracena) / (1.0 + @pdvstopa) * @pdvstopa) as povecanje_pdva,
        if(promena = 0, 0.0, bb.prod_cena - @staracena) as povecanje_cene,
        @staracena := bb.prod_cena as nova_cena,
        bb.art_pg as poreska_grupa,
        @stanje := if(promena = 0, kolicina, @kolicina) as staro_stanje,
        @kolicina := if(promena = 0, kolicina, @kolicina + kolicina) as stanje
      from (
        select
            zz.*,
            sum(zz.kol) as kolicina
          from (
            select
                if(@aid <> artikal_id, @promena := 0, if(@cena <> prodajna_cena, @promena := @promena + 1, @promena)) as promena,
                if(@aid <> artikal_id, @aid := artikal_id, @aid) as art_id,
                @cena := prodajna_cena as prod_cena,
                temp.artikal_naziv as art_naziv,
                temp.kolicina as kol,
                temp.art_pg as art_pg,
                temp.art_jed_mere as art_jed_mere
              from (
                select
                    a.id as artikal_id,
                    a.name as artikal_naziv,
                    a.cena as artikal_cena,
                    cd.id as id,
                    (select zakljucenje from zd where datum = @date and pocetak = 1) as datum,
                    coalesce(c.prodajnaCena, a.cena) as prodajna_cena,
                    coalesce(sum(ds.beloulaz - ds.beloizlaz), 0) as kolicina,
                    a.poreskaGrupa as art_pg,
                    a.jedinicaMere as art_jed_mere
                  from artikal a
                    left join cenovnikzadan cd on cd.zadan = (select min(zaDan) from cenovnikzadan where zadan >= @date and zakljucen = true)
                    left join cenazadan c on c.cenovnik_id = cd.id and c.artikal_id = a.id
                    left join dnevnostanje ds on ds.artikalID = a.id and ds.datum < @date and ds.odeljenje_id <> 1
                  group by a.id
                union all
                select
                    a.id,
                    a.name,
                    a.cena,
                    cd.id,
                    coalesce((select zakljucenje from zd where datum = @date and pocetak = 0), curdate()) as datum,
                    coalesce(c.prodajnaCena, a.cena),
                    0 as kolicina,
                    a.poreskaGrupa as art_pg,
                    a.jedinicaMere as art_jed_mere
                  from artikal a
                    left join cenovnikzadan cd on cd.zadan = (select min(zaDan) from cenovnikzadan where zadan > @date and zakljucen = true)
                    left join cenazadan c on c.cenovnik_id = cd.id and c.artikal_id = a.id
                union all
                  select
                    a.id,
                    a.name,
                    a.cena,
                    r.id,
                    r.datum,
                    coalesce(round(sr.cena * (100 - r.popust) / 100), a.cena) as cena_sa_popustom,
                    sum(sr.kolicina) * -1.0 as kolicina,
                    a.poreskaGrupa as art_pg,
                    a.jedinicaMere as art_jed_mere
                  from racun r
                    inner join stavkaracuna sr on r.id = sr.racun_id
                    inner join artikal a on sr.artikal_id = a.id
                  where r.datum between (select zakljucenje from zd where datum = @date and pocetak = 1) and coalesce((select zakljucenje from zd where datum = @date and pocetak = 0), now())
                  group by a.id, cena_sa_popustom
            ) as temp
              order by artikal_id, datum
          ) as zz
          group by art_id, promena, prod_cena
          order by art_naziv
      ) as bb
  ) as source
  where promena > 0 and staro_stanje != 0;