SELECT
    sr.id as srid,
    sr.naziv AS artikal,
    a.barcode AS artikalsifra,
    a.name AS artikalnaziv,
    a.mera AS mera,
    sr.artikal_id AS artikalid,
    sr.kolicina AS kolicina,
    r.datum as datum,
    a.cena AS prodajnacena,
    if(a.dozvoljenPopust,(sr.cena * (100 - coalesce(r.popust, 0))/100), sr.cena) AS prodajnacenapopust,
    r.id AS racunid,
    r.crnoplacanje AS crnoplacanje,
    count(distinct(p.nacin)) as brojbelihplacanja,
    if(count(distinct(p.nacin)) > 1, 'KOMBINOVANO', p.nacin) AS beloplacanje
  FROM stavkaracuna sr
    INNER JOIN tura t
      ON sr.tura_id = t.id
    LEFT OUTER JOIN racun r
      ON sr.racun_id = r.id
    LEFT OUTER JOIN placanje p
      ON r.id = p.racun_id
    LEFT OUTER JOIN artikal a
      ON sr.artikal_id = a.id
    LEFT OUTER JOIN podgrupaartikala pg
      ON a.podgrupa_id = pg.id
    LEFT OUTER JOIN artikal_odeljenje ao
      ON a.id = ao.artikli_id
    LEFT OUTER JOIN odeljenje o
      ON ao.odeljenja_id = o.id
    LEFT OUTER JOIN kasa k
      ON r.kasa_id = k.id
  WHERE (
        find_in_set(p.nacin, ?)
        OR find_in_set(r.crnoplacanje, ?)
        OR if(?,(p.nacin is null and r.crnoplacanje is null), FALSE) 
      )
    AND (
        (r.datum BETWEEN ? AND ?)
        OR (sr.racun_id is null AND t.datum BETWEEN ? AND ?)
      )
    AND find_in_set(o.id, ?)
    AND (
        find_in_set(k.id, ?)
        OR sr.racun_id is null
      )
      AND(a.tip <> ('DODA') AND a.cena <> 0)
    AND find_in_set(pg.id, ?)
  GROUP BY sr.id, sr.naziv, a.barCode, a.name, a.mera, sr.artikal_id, sr.kolicina, r.datum, a.cena, r.id 
  ORDER BY  artikal