	  SELECT
    mp.id as srid,
    "MENI" AS podgrupa,
    mp.naziv AS artikal,
    mp.MENI_ID AS artikalsifra,
    mp.naziv AS artikalnaziv,
    '1' AS mera,
    'KOM' AS jedinica,
    mp.MENI_ID AS artikalid,
    mp.kolicina AS kolicina,
    mp.cena AS prodajnacena,
    mp.cena AS prodajnacenapopust,
    r.id AS racunid,
    r.crnoplacanje AS crnoplacanje,
    count(distinct(p.nacin)) as brojbelihplacanja,
    if(count(distinct(p.nacin)) > 1, 'KOMBINOVANO', p.nacin) AS beloplacanje,
    mp.MENI_ID AS sifra
  FROM racun r
    INNER JOIN menipromet mp ON mp.racun_id = r.id
    LEFT JOIN placanje p ON r.id = p.racun_id
    LEFT JOIN kasa k ON r.kasa_id = k.id
  WHERE 
    (r.datum BETWEEN ?4 AND ?5 ) AND ( locate(p.nacin, ?1 ) OR locate(r.crnoplacanje, ?2 )) 
  GROUP BY srid, artikal, racunid
  
  union
  
  SELECT
    sr.id as srid,
    pg.naziv AS podgrupa,
    sr.naziv AS artikal,
    a.barcode AS artikalsifra,
    a.name AS artikalnaziv,
    a.mera AS mera,
    a.jedinicaMere AS jedinica,
    sr.artikal_id AS artikalid,
    sr.kolicina AS kolicina,
    a.cena AS prodajnacena,
    (sr.cena * (100 - coalesce(r.popust*a.dozvoljenPopust, 0))/100) AS prodajnacenapopust,
    r.id AS racunid,
    r.crnoplacanje AS crnoplacanje,
    count(distinct(p.nacin)) as brojbelihplacanja,
    if(count(distinct(p.nacin)) > 1, 'KOMBINOVANO', p.nacin) AS beloplacanje,
    a.sifra AS sifra
  FROM stavkaracuna sr
    INNER JOIN tura t
      ON sr.tura_id = t.id
    LEFT OUTER JOIN racun r
      ON sr.racun_id = r.id
    LEFT JOIN placanje p
      ON r.id = p.racun_id
    LEFT OUTER JOIN artikal a
      ON sr.artikal_id = a.id
    LEFT OUTER JOIN podgrupaartikala pg
      ON a.podgrupa_id = pg.id
    LEFT JOIN kasa k
      ON r.kasa_id = k.id
    LEFT JOIN artikal_odeljenje ao ON ao.artikli_id = a.id
  WHERE (r.datum BETWEEN ?4 AND ?5 ) AND ( locate(p.nacin, ?1 ) 
      	OR locate(r.crnoplacanje, ?2 )
        OR if( ?3 ,(p.nacin is null and r.crnoplacanje is null), FALSE) 
      )
  	    AND (
        find_in_set(k.id, ?8 )
      )
      AND(a.tip <> ('DODA') OR a.cena <> 0) AND find_in_set(pg.id, ?9 )
      AND sr.RACUN_ID  NOT IN ( SELECT RACUN_ID FROM menipromet WHERE datum >= ?6 and datum <= ?7 )
    AND find_in_set(ao.odeljenja_id, ?10) 
  GROUP BY srid, artikal
  order by podgrupa ASC, artikal ASC 