-- Dumping structure for procedure restoran.analiza_prodaje_po_satima

CREATE DEFINER = `root`@`localhost` PROCEDURE `kpu_knjiga`(IN `godina` INT, IN `DatumKPU` DATE)
	LANGUAGE SQL
	NOT DETERMINISTIC
	CONTAINS SQL
	SQL SECURITY DEFINER
	COMMENT ''
BEGIN
	DECLARE id INTEGER;
	DECLARE datum TIMESTAMP;
	DECLARE opis VARCHAR (512);
	DECLARE zaduzenje DECIMAL (15,2) DEFAULT 0;
	DECLARE Pazar DECIMAL (15,2) DEFAULT 0;
	DECLARE test BIT DEFAULT 0;
	
	
	DROP TABLE IF EXISTS temp_kpu;
	
	CREATE TABLE temp_kpu (
		Id INTEGER, 
		Datum TIMESTAMP,
		Opis VARCHAR (512),
		Zaduzenje DECIMAL (15,2) DEFAULT 0,
		Razduzenje DECIMAL (15,2) DEFAULT 0
	);
	
	SELECT YEAR(MIN(zd.datum)) < YEAR(NOW()) FROM zd INTO test;
	
	CASE
    	WHEN test = 1 THEN 
    		INSERT INTO temp_kpu
				SELECT 1, LAST_DAY(DATE_ADD(NOW() - INTERVAL 1 YEAR, INTERVAL 12-MONTH(NOW()) MONTH)), 'Donos', CAST(s.actual AS DECIMAL(12,2)), 0
				FROM setting s 
			WHERE s.name = 'pku.knjiga.donos';
		ELSE
			INSERT INTO temp_kpu
			SELECT 1, (SELECT MIN(zd.datum) FROM zd), 'Donos', 0, 0;
	END CASE;
	
	INSERT INTO temp_kpu
	SELECT 2, r.datum, 'Pazar', 0, ROUND(sum(sr.kolicina * sr.cena),2)
	FROM stavkaracuna sr
	LEFT JOIN racun r ON r.id = sr.RACUN_ID 
	LEFT JOIN artikal_odeljenje ao ON ao.ARTIKLI_ID = sr.ARTIKAL_ID
	WHERE ao.ODELJENJA_ID IN (SELECT o.id FROM odeljenje o WHERE o.naziv <> 'MAGACIN')
	AND YEAR(r.datum) = godina
	AND DATE(r.datum) <= datumKPU
	GROUP BY DATE(r.datum)
	ORDER BY r.id;
	
	INSERT INTO temp_kpu
	SELECT 3, t.datumTrebovanja, CONCAT(t.brTrebovanja, ' ', sg.naziv, ', ', sg.mesto) AS Opis,
	ROUND(SUM(IF(t.tip = 'DIREKTNO_SA_KNJIZ', ps.kolicina / a.mera * ps.prodajnaCena, 0)),2) AS ulazSank,
	0 AS Pazar	
	FROM trebovanje t
	LEFT JOIN prijemnica p ON p.id = t.PRIJEMNICA_ID
	LEFT JOIN prijemnicastavka ps ON ps.PRIJEMNICA_ID = p.id
	LEFT JOIN stalnigost sg ON p.DOBAVLJAC_ID = sg.id	
	LEFT JOIN artikal a ON a.id = ps.ARTIKAL_ID
	WHERE YEAR(t.datumTrebovanja) = godina
	AND DATE(t.datumTrebovanja) <= datumKPU	
	AND t.tip = 'DIREKTNO_SA_KNJIZ'
	AND a.tip = 'PROD'
	GROUP BY p.id
	ORDER BY t.datumTrebovanja;
	
	INSERT INTO temp_kpu
	SELECT 4, r.datum, 'Zaduzenje hrane', ROUND(sum(sr.kolicina * sr.cena),2), 0
	FROM stavkaracuna sr
	LEFT JOIN racun r ON r.id = sr.RACUN_ID 
	LEFT JOIN artikal_odeljenje ao ON ao.ARTIKLI_ID = sr.ARTIKAL_ID		
	WHERE ao.ODELJENJA_ID IN (SELECT o.id FROM odeljenje o WHERE o.naziv = 'KUHINJA')
	AND YEAR(r.datum) = godina
	AND DATE(r.datum) <= datumKPU
	GROUP BY DATE(r.datum)
	ORDER BY r.id;
	
	SELECT * FROM temp_kpu tk ORDER BY DATE(tk.Datum), tk.Id;
	
	DROP TABLE IF EXISTS temp_kpu;
END