set @from=?,
    @to=?,
    @departments=?,
    @warehouse=?,
    @subGroups=?,
    @subGroupsSort=?,
    @excludedArtTypes=?,
    @onlyChanges=?,
    @white=?,
    @black=?,
    @lastPrice=?,
    @lastPriceWithBlack=?,
    @pgA=?,
    @pgG=?,
    @pgD=?,
    @pgDJ=?,
    @pgE=?,
    @pgZJ=?,
    @pgI=?,
    @pgJ=?,
    @pgK=?;

SELECT odpg AS 'kljuc',
       nazivartikla AS 'artikal',
       jm AS 'jm',
       ROUND(pocetnoBelo, 4) AS 'pocetnoBelo',
       ROUND(pocetnoCrno, 4) AS 'pocetnoCrno',
       ROUND(ulazBelo, 4) AS 'ulazBelo',
       ROUND(ulazCrno, 4) AS 'ulazCrno',
       ROUND(izlazBelo, 4) AS 'izlazBelo',
       ROUND(izlazCrno, 4) AS 'izlazCrno',
       ROUND(pocetnoBelo + ulazBelo - izlazBelo, 4) AS 'zavrsnoBelo',
       ROUND(pocetnoCrno + ulazCrno - izlazCrno, 4) AS 'zavrsnoCrno'
FROM
  (SELECT CONCAT(o.id, '. ', o.naziv, if(@subGroupsSort, CONCAT('-', pg.naziv), '')) AS 'odpg',
          a.name AS 'nazivartikla',
          COALESCE(a.mera, 1) AS 'mera',
          a.jedinicaMere AS 'jm',
          ROUND(SUM(IF(ds.datum < @from, IF(@white, COALESCE((ds.beloUlaz - ds.beloIzlaz), 0), 0), 0)), 4) AS pocetnoBelo,
          ROUND(SUM(IF(ds.datum < @from, IF(@black, COALESCE((ds.crnoUlaz - ds.crnoIzlaz), 0), 0), 0)), 4) AS pocetnoCrno,
          ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to, IF(@white, COALESCE(ds.beloUlaz,  0), 0), 0)), 4) AS ulazBelo,
                                 ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to, IF(@black, COALESCE(ds.crnoUlaz, 0), 0), 0)), 4) AS ulazCrno,
          ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to, IF(@white, COALESCE(ds.beloIzlaz, 0), 0), 0)), 4) AS izlazBelo,
          ROUND(SUM(IF(ds.datum >= @from
                       AND ds.datum <= @to,  IF(@black, COALESCE(ds.crnoIzlaz, 0), 0), 0)), 4) AS izlazCrno 
   FROM dnevnostanje ds
   LEFT JOIN artikal a ON ds.artikalID = a.id
   LEFT JOIN odeljenje o ON ds.ODELJENJE_ID = o.id
   LEFT JOIN podgrupaartikala pg ON a.PODGRUPA_ID = pg.id
   WHERE ds.datum <= @to
     AND a.blokiran = 0
     AND FIND_IN_SET(a.tip, @excludedArtTypes) = 0
     AND FIND_IN_SET(ds.ODELJENJE_ID,  @departments) > 0
     AND FIND_IN_SET(pg.id,  @subGroups) > 0
   GROUP BY ds.artikalID,
            ds.ODELJENJE_ID
   ORDER BY o.id,
            if(@subGroupsSort, odpg, 1),
            nazivartikla) AS SOURCE
WHERE IF(@onlyChanges, ulazBelo <> 0
         OR izlazBelo <> 0, TRUE);