/*
 * Decompiled with CFR 0.152.
 */
package swt.proba;

import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.NivelacijaStara;
import com.dev63.restoran.model.NivelacijaStaraStavka;
import com.dev63.restoran.model.PodgrupaArtikala;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NivelacijaUnos {
    private List<Artikal> articles;
    private List<Artikal> resultArts = new LinkedList<Artikal>();
    private TableViewer itemTV;
    private NivelacijaStara nivelacija;
    private TableColumnLayout itemTcl;
    private ListViewer lArticles;

    public NivelacijaUnos(Shell parent, NivelacijaStara n) {
        if (n == null) {
            n = new NivelacijaStara();
            n.setBroj(this.nextNivelationNumber());
            n.setBrNivelacije(this.formNivelationMark(n.getBroj()));
        }
        this.nivelacija = n;
        this.articles = new LinkedList<Artikal>();
        this.loadTestData();
        Shell shell = new Shell(parent, 34912);
        shell.setText("Unos nivelacije");
        shell.setLayout((Layout)new GridLayout(3, true));
        shell.setMaximized(true);
        Group nc = new Group((Composite)shell, 64);
        nc.setText("Podaci o nivelaciji");
        nc.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        nc.setLayout((Layout)new RowLayout());
        Group carts = new Group((Composite)shell, 32);
        carts.setText("Pretraga artikala");
        carts.setLayoutData((Object)new GridData(4, 4, false, true, 1, 3));
        carts.setLayout((Layout)new GridLayout());
        Label lbn = new Label((Composite)nc, 0x1000000);
        lbn.setText("BrojNivelacije: ");
        Text tbn = new Text((Composite)nc, 2048);
        tbn.setText(n.getBrNivelacije());
        tbn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                NivelacijaUnos.this.nivelacija.setBrNivelacije(t.getText());
                System.out.println(NivelacijaUnos.this.nivelacija.getBrNivelacije());
            }
        });
        Group ct = new Group((Composite)shell, 16);
        ct.setText("Stavke nivelacije");
        ct.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ct.setLayout((Layout)new FillLayout());
        Composite ctin = new Composite((Composite)ct, 2048);
        this.itemTcl = new TableColumnLayout();
        ctin.setLayout((Layout)this.itemTcl);
        this.itemTV = new TableViewer(ctin, 66050);
        this.itemTV.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.itemTV.getTable().setLinesVisible(true);
        this.itemTV.getTable().setHeaderVisible(true);
        this.makeColumns(this.itemTV, this.itemTcl);
        final Text artSrch = new Text((Composite)carts, 2052);
        artSrch.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button bSrch = new Button((Composite)carts, 8);
        bSrch.setLayoutData((Object)new GridData(4, 4, true, false));
        bSrch.setText("Tra\u017ei");
        Listener srchList = new Listener(){

            public void handleEvent(Event event) {
                String criteria = artSrch.getText();
                switch (event.type) {
                    case 2: {
                        if (!event.widget.equals(artSrch) || event.keyCode != 0x1000050 && event.keyCode != 13) break;
                        NivelacijaUnos.this.searchArticles(criteria);
                        artSrch.setText("");
                        System.out.println("text");
                        break;
                    }
                    case 13: {
                        if (!event.widget.equals(bSrch)) break;
                        NivelacijaUnos.this.searchArticles(criteria);
                        artSrch.setText("");
                        System.out.println("dugme");
                    }
                }
            }
        };
        artSrch.addListener(2, srchList);
        bSrch.addListener(13, srchList);
        this.lArticles = new ListViewer((Composite)carts, 2564);
        this.lArticles.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.lArticles.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lArticles.setInput(this.resultArts);
        Listener addListener = new Listener(){

            public void handleEvent(Event event) {
            }
        };
        this.lArticles.getControl().addListener(2, addListener);
        if (this.nivelacija != null) {
            this.itemTV.setInput(this.nivelacija.getStavke());
        }
        Composite ctrls = new Composite((Composite)shell, 0);
        ctrls.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        ctrls.setLayout((Layout)new RowLayout());
        Button bSave = new Button(ctrls, 8);
        bSave.setText("Listaj");
        bSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Nivelacija - " + NivelacijaUnos.this.nivelacija.getBrNivelacije());
                System.out.println("Datum nivelacije - " + StatLogic.getDateString(NivelacijaUnos.this.nivelacija.getDatum()));
                System.out.println("Datum unosa - " + StatLogic.getDateString(NivelacijaUnos.this.nivelacija.getDatumUnosa()));
                System.out.println("Uneo - " + NivelacijaUnos.this.nivelacija.getUneo());
                for (NivelacijaStaraStavka ns : NivelacijaUnos.this.nivelacija.getStavke()) {
                    System.out.println("");
                    System.out.println("\tNaziv stavke - " + ns.getNaziv());
                    System.out.println("\tStara cena stavke - " + StatLogic.getNumber02(ns.getStaraCena()));
                    System.out.println("\tNova cena stavke - " + StatLogic.getNumber02(ns.getNovaCena()));
                    System.out.println("\tNova cena artikla - " + StatLogic.getNumber02(ns.getArtikal().getCena()));
                    System.out.println("\tPromena artikla - " + StatLogic.getNumber02(ns.getPromena()));
                }
            }
        });
        Button bRemItem = new Button(ctrls, 8);
        bRemItem.setText("Ukloni stavku");
        bRemItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NivelacijaUnos.this.removeItem();
                System.out.println("Nivelacija - " + NivelacijaUnos.this.nivelacija.getBrNivelacije());
                System.out.println("Datum nivelacije - " + StatLogic.getDateString(NivelacijaUnos.this.nivelacija.getDatum()));
                System.out.println("Datum unosa - " + StatLogic.getDateString(NivelacijaUnos.this.nivelacija.getDatumUnosa()));
                System.out.println("Uneo - " + NivelacijaUnos.this.nivelacija.getUneo());
                for (NivelacijaStaraStavka ns : NivelacijaUnos.this.nivelacija.getStavke()) {
                    System.out.println("");
                    System.out.println("\tNaziv stavke - " + ns.getNaziv());
                    System.out.println("\tStara cena stavke - " + StatLogic.getNumber02(ns.getStaraCena()));
                    System.out.println("\tNova cena stavke - " + StatLogic.getNumber02(ns.getNovaCena()));
                    System.out.println("\tNova cena artikla - " + StatLogic.getNumber02(ns.getArtikal().getCena()));
                    System.out.println("\tPromena artikla - " + StatLogic.getNumber02(ns.getPromena()));
                }
            }
        });
        shell.open();
        this.itemTV.editElement((Object)parent, 3);
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        parent.dispose();
    }

    private void addItem() {
        int curIndex = this.lArticles.getList().getSelectionIndex();
        Artikal curArt = null;
        if (curIndex >= 0) {
            curArt = (Artikal)this.lArticles.getElementAt(curIndex);
        }
        if (curArt != null) {
            NivelacijaStaraStavka ns = new NivelacijaStaraStavka();
            ns.setArtikal(curArt);
            ns.setNaziv(curArt.getName());
            ns.setNivelacija(this.nivelacija);
            ns.setStaraCena(curArt.getCena());
            ns.setNovaCena(curArt.getCena());
            ns.setPromena(0.0);
            this.nivelacija.getStavke().add(ns);
        }
    }

    private void removeItem() {
        ISelection sel = this.itemTV.getSelection();
        IStructuredSelection sSel = null;
        if (sel != null && sel instanceof IStructuredSelection) {
            sSel = (IStructuredSelection)sel;
        }
        if (sSel != null) {
            for (NivelacijaStaraStavka ns : sSel) {
                this.nivelacija.getStavke().remove(ns);
            }
        }
        this.itemTV.refresh();
    }

    private void searchArticles(String criteria) {
        final String filter = criteria;
        if (filter == null || filter.length() < 3) {
            return;
        }
        String filterRX = filter.replaceAll(" ", ".*");
        Pattern pFil = Pattern.compile(filterRX, 66);
        this.resultArts.clear();
        LinkedList<Artikal> tempList = new LinkedList<Artikal>();
        for (Artikal artikal : this.articles) {
            Matcher mN = pFil.matcher(artikal.getName());
            if (!mN.find() && (artikal.getBarCode() == null || !artikal.getBarCode().toUpperCase().contains(filter.toUpperCase()))) continue;
            tempList.add(artikal);
        }
        Comparator<Artikal> srchComp = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal o1, Artikal o2) {
                String filt = filter.split(" ")[0];
                do {
                    boolean cond1 = o1.getName().toLowerCase().startsWith(filt.toLowerCase());
                    boolean cond2 = o2.getName().toLowerCase().startsWith(filt.toLowerCase());
                    if (cond1 && cond2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if (cond1 && !cond2) {
                        return -1;
                    }
                    if (cond1 || !cond2) continue;
                    return 1;
                } while ((filt = filt.substring(0, filt.length() - 1)).length() > 0);
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(tempList, srchComp);
        this.resultArts.addAll(tempList);
        this.lArticles.refresh();
    }

    private void makeColumns(TableViewer tv, TableColumnLayout tcl) {
        TableViewerColumn tvc1 = new TableViewerColumn(tv, 16384);
        tvc1.getColumn().setText("Naziv artikla");
        tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return ns.getNaziv();
            }
        });
        tcl.setColumnData((Widget)tvc1.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        TableViewerColumn tvc2 = new TableViewerColumn(tv, 16384);
        tvc2.getColumn().setText("Podgrupa");
        tvc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return ns.getArtikal().getPodgrupa().getNaziv();
            }
        });
        tcl.setColumnData((Widget)tvc2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        TableViewerColumn tvc3 = new TableViewerColumn(tv, 16384);
        tvc3.getColumn().setText("Stara cena");
        tvc3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return StatLogic.getNumber02(ns.getStaraCena());
            }
        });
        tcl.setColumnData((Widget)tvc3.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        TableViewerColumn tvc4 = new TableViewerColumn(tv, 16384);
        tvc4.getColumn().setText("Nova cena");
        tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return StatLogic.getNumber02(ns.getNovaCena());
            }
        });
        tvc4.setEditingSupport((EditingSupport)new NewPriceEditingSupport(this.itemTV, 3));
        tcl.setColumnData((Widget)tvc4.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        TableViewerColumn tvc6 = new TableViewerColumn(tv, 16384);
        tvc6.getColumn().setText("Nova cena artikla");
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return StatLogic.getNumber02(ns.getArtikal().getCena());
            }
        });
        tcl.setColumnData((Widget)tvc6.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        TableViewerColumn tvc5 = new TableViewerColumn(tv, 16384);
        tvc5.getColumn().setText("Promena");
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
                return StatLogic.getNumber02(ns.getPromena()) + "%";
            }
        });
        tcl.setColumnData((Widget)tvc5.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
    }

    private void loadTestData() {
        int i;
        this.nivelacija = new NivelacijaStara();
        this.nivelacija.setBrNivelacije("1/2013");
        this.nivelacija.setBroj(1);
        PodgrupaArtikala[] pgarr = new PodgrupaArtikala[5];
        for (i = 0; i < pgarr.length; ++i) {
            PodgrupaArtikala pga = new PodgrupaArtikala();
            pga.setNaziv("PG " + i);
            pga.setSkrNaziv(pga.getNaziv());
            pgarr[i] = pga;
        }
        for (i = 0; i < 48; ++i) {
            Artikal a = new Artikal();
            a.setName("Artikal " + i);
            a.setSkrNaziv("Artikal " + i);
            a.setPodgrupa(pgarr[i % pgarr.length]);
            a.setCena(Double.valueOf((i % 4 + 1) * 100));
            this.articles.add(a);
            NivelacijaStaraStavka ns = new NivelacijaStaraStavka();
            ns.setArtikal(a);
            ns.setNaziv(a.getName());
            ns.setNivelacija(this.nivelacija);
            ns.setStaraCena(a.getCena());
            ns.setNovaCena(a.getCena());
            ns.setPromena(0.0);
            this.nivelacija.getStavke().add(ns);
        }
        int ss = this.nivelacija.getStavke().size();
        for (int i2 = 0; i2 < 20; ++i2) {
            Artikal a = new Artikal();
            a.setName("Artikal " + (i2 + ss));
            a.setSkrNaziv("Artikal " + (i2 + ss));
            a.setPodgrupa(pgarr[i2 % pgarr.length]);
            a.setCena(Double.valueOf((i2 % 4 + 1) * 100));
            this.articles.add(a);
        }
    }

    public static void main(String[] args) {
        Display d = new Display();
        Shell s = new Shell(d, 1264);
        s.open();
        new NivelacijaUnos(s, null);
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        d.dispose();
        System.out.println("Display disposed");
    }

    private Integer nextNivelationNumber() {
        return 1;
    }

    private String formNivelationMark(Integer nivelationNumber) {
        return nivelationNumber + "/" + new SimpleDateFormat("yyyy").format(new Date());
    }

    private class NewPriceEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private int editorColumnIndex;

        public NewPriceEditingSupport(TableViewer viewer, int editorColIndex) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editorColumnIndex = editorColIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor tce = new TextCellEditor((Composite)this.viewer.getTable());
            tce.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    int curIndex = NewPriceEditingSupport.this.viewer.getTable().getSelectionIndex();
                    int itemCount = NewPriceEditingSupport.this.viewer.getTable().getItemCount();
                    switch (e.keyCode) {
                        case 0x1000002: 
                        case 0x1000050: {
                            System.out.println("DOLE");
                            ISelection sel = NewPriceEditingSupport.this.viewer.getSelection();
                            IStructuredSelection ss = null;
                            if (sel != null && sel instanceof IStructuredSelection) {
                                ss = (IStructuredSelection)sel;
                            }
                            if (ss != null) {
                                // empty if block
                            }
                            if (curIndex < 0) break;
                            NewPriceEditingSupport.this.viewer.editElement(NewPriceEditingSupport.this.viewer.getElementAt((curIndex + 1 + itemCount) % itemCount), NewPriceEditingSupport.this.editorColumnIndex);
                            break;
                        }
                        case 0x1000001: {
                            System.out.println("GORE");
                            if (curIndex < 0) break;
                            NewPriceEditingSupport.this.viewer.editElement(NewPriceEditingSupport.this.viewer.getElementAt((curIndex - 1 + itemCount) % itemCount), NewPriceEditingSupport.this.editorColumnIndex);
                        }
                    }
                }
            });
            return tce;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return StatLogic.getNumber02(((NivelacijaStaraStavka)element).getNovaCena());
        }

        protected void setValue(Object element, Object value) {
            Double novaCena = StatLogic.parseDouble02Suppress(String.valueOf(value));
            NivelacijaStaraStavka ns = (NivelacijaStaraStavka)element;
            Double promena = novaCena / ns.getStaraCena() - 1.0;
            ns.setNovaCena(novaCena);
            ns.setPromena(promena * 100.0);
            ns.getArtikal().setCena(novaCena);
            this.viewer.update(element, null);
        }
    }
}

