/*
 * Decompiled with CFR 0.152.
 */
package swt.proba;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.stampa.InvoicePrintBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPrint;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NebulaPaperClipsTester {
    private static String fontName = "Arial";
    private static int textSize = 7;
    private static int titleTextSize = 36;
    private static int headingSize = 9;

    public static void main(String[] args) {
        InvoicePrintBuilder.InvoiceData id = new InvoicePrintBuilder.InvoiceData(true);
        InvoicePrintBuilder.printToDefault((Print)InvoicePrintBuilder.createNewDocument(InvoicePrintBuilder.makeTitle(id), InvoicePrintBuilder.createBody(new Print[]{InvoicePrintBuilder.makeTransactionHeader(id, ""), InvoicePrintBuilder.makeItems(id), InvoicePrintBuilder.makeTaxes(id, null)}), (Print)InvoicePrintBuilder.makePageFooter(id)), "Proba", 3);
        InvoicePrintBuilder.printToDefault((Print)InvoicePrintBuilder.createNewDocument(InvoicePrintBuilder.makeTitle(id), InvoicePrintBuilder.createBody(new Print[]{InvoicePrintBuilder.makeCashHeader(id), InvoicePrintBuilder.makeItems(id), InvoicePrintBuilder.makeTaxes(id, null), InvoicePrintBuilder.makePayments(id)}), (Print)InvoicePrintBuilder.makePageFooter(id)), "Proba", 2);
        InvoicePrintBuilder.printToDefault((Print)InvoicePrintBuilder.createNewDocument(InvoicePrintBuilder.makeTitle(id), InvoicePrintBuilder.createBody(new Print[]{InvoicePrintBuilder.makeOfferHeader(id), InvoicePrintBuilder.makeItems(id), InvoicePrintBuilder.makeTaxes(id, null), InvoicePrintBuilder.makePayments(id)}), (Print)InvoicePrintBuilder.makePageFooter(id)), "Proba", 2);
    }

    public static GridPrint makeTitle(String logoPath, String title) {
        GridPrint header;
        GridPrint mainPrint = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 600, 600)});
        FontData fd = new FontData(fontName, titleTextSize, 1);
        File f = new File(logoPath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(NebulaPaperClipsTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        mainPrint.add((Print)new EmptyPrint(20, 20));
        if (fis == null) {
            header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 600, 1)});
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
            header.add((Print)new TextPrint(title, fd, 0x1000000));
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
        } else {
            ImageData id = new ImageData((InputStream)fis);
            id = id.scaledTo(Math.round(Float.valueOf(id.width).floatValue() / Float.valueOf(id.height).floatValue() * Float.valueOf(400.0f).floatValue()), 400);
            header = new ImagePrint(id);
            ((ImagePrint)header).setDPI(300, 300);
        }
        mainPrint.add(0x1000000, 0x1000000, (Print)header, -1);
        mainPrint.add((Print)new EmptyPrint(20, 20));
        return mainPrint;
    }

    private static GridPrint makeHeader(HeaderData hd) {
        String fakturaL = "FAKTURA br:";
        String datumPL = "Datum prometa:";
        String mestoPL = "Mesto prometa:";
        String datumIL = "Datum izdavanja:";
        String mestoIL = "Mesto izdavanja:";
        String datumVL = "Datum valute:";
        String brojRacuna = hd.getBrRacuna() + "/" + new SimpleDateFormat("yyyy").format(new Date());
        String datumP = StatLogic.getDateString(hd.getDatumPrometa());
        String mestoP = hd.getMestoIzdavanja();
        String datumI = StatLogic.getDateString(hd.getDatumIzdavanja());
        String mestoI = hd.getMestoPrometa();
        String datumV = StatLogic.getDateString(hd.getDatumValute());
        String podaciOKupcu = "Podaci o kupcu";
        String pibL = "PIB: ";
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 300, 0), new GridColumn(0x1000000, 300, 0)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, 40, 0), new GridColumn(16384, 100, 0), new GridColumn(16384, 10, 0), new GridColumn(16384, 120, 0), new GridColumn(16384, 20, 0)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, 100, 1)});
        gpRDLbls.add(131072, (Print)new TextPrint(fakturaL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(datumPL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(mestoPL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(datumVL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, 120, 1)});
        gpRData.add((Print)new TextPrint(brojRacuna, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoI, fdt, 16384));
        gpRData.add((Print)new TextPrint(datumP, fdt, 16384));
        gpRData.add((Print)new TextPrint(mestoP, fdt, 16384));
        gpRData.add((Print)new TextPrint(datumV, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 20, 1), new GridColumn(0x1000000, 240, 1), new GridColumn(0x1000000, 40, 1)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 240, 1)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + podaciOKupcu, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getNazivKupca(), fdbtb, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(hd.getAdresaKupca(), fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(pibL + hd.getPibKupca(), fdbt, 0x1000000));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static GridPrint makeItems(List<StavkaRacuna> lsr) {
        String rb = "Rb";
        String naziv = "Naziv";
        String jm = "J.M.";
        String kolicina = "Koli\u010dina";
        String cena = "Cena";
        String popustPC = "Popust";
        String pdvPC = "PDV";
        String pdvIznos = "Iznos PDV";
        String cenaBPDV = "Iznos bez PDV";
        String iznos = "Iznos";
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(3, 1);
        GridPrint gpItems = new GridPrint(new GridColumn[]{new GridColumn(131072, 20, 20), new GridColumn(16384, 160, 160), new GridColumn(0x1000000, 25, 25), new GridColumn(131072, 45, 45), new GridColumn(131072, 65, 65), new GridColumn(131072, 40, 40), new GridColumn(131072, 40, 40), new GridColumn(131072, 65, 65), new GridColumn(131072, 70, 70), new GridColumn(131072, 70, 70)});
        gpItems.setLook((GridLook)dgl);
        RGB lineCol = new RGB(64, 64, 64);
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(lineCol);
        FontData fdt = new FontData(fontName, textSize, 0);
        gpItems.addHeader((Print)new EmptyPrint(10, 5), -1);
        gpItems.addHeader((Print)lp, -1);
        gpItems.addHeader(0x1000000, (Print)new TextPrint(rb, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(naziv, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(jm, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(kolicina, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cena, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(popustPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvIznos, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaBPDV, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(iznos, fdt, 0x1000000));
        gpItems.addHeader((Print)lp, -1);
        int i = 0;
        for (StavkaRacuna sr : lsr) {
            double pdvStopa = Konstante.getPdvPoPG(sr.getArtikal().getPoreskaGrupa());
            double iznosBPdv = sr.getVrednost() / (1.0 + pdvStopa);
            double iznosPdv = iznosBPdv * pdvStopa;
            gpItems.add(131072, (Print)new TextPrint("" + ++i, fdt, 0x1000000));
            gpItems.add(16384, (Print)new TextPrint(sr.getNaziv(), fdt, 0x1000000));
            gpItems.add(16384, (Print)new TextPrint(sr.getArtikal().getJedinicaMere(), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(sr.getKolicina()), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getCena()), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getRacun().getPopust()) + "%", fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(iznosPdv), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(iznosBPdv), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getVrednost()), fdt, 0x1000000));
        }
        gpItems.add((Print)lp, -1);
        return gpItems;
    }

    public static GridPrint makePageFooter(String preduzece, String adresa, String pib, String matBroj, String banka, String racun, String uPDV, String delatnost, String tel, String fax, String web, String email) {
        String preduzeceL = "Preduze\u0107e";
        String adresaL = "Adresa";
        String pibL = "PIB";
        String matBrojL = "Mat. Broj";
        String bankaL = "Banka";
        String racunL = "Ra\u010dun";
        String uPDVL = "U sistemu PDV";
        String delatnostL = "\u0160ifra delstnosti";
        String telL = "Tel";
        String faxL = "Fax";
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(1, 1);
        GridPrint gpCompany = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175), new GridColumn(0x1000000, 175, 175), new GridColumn(0x1000000, 250, 250)});
        gpCompany.setLook((GridLook)dgl);
        GridPrint gpLeft = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175)});
        gpLeft.setLook((GridLook)dgl);
        gpLeft.add((Print)new TextPrint(preduzeceL + ": " + preduzece, fdtb, 0x1000000));
        gpLeft.add((Print)new TextPrint(adresaL + ": " + adresa, fdt, 0x1000000));
        gpLeft.add((Print)new TextPrint(pibL + ": " + pib, fdt, 0x1000000));
        gpLeft.add((Print)new TextPrint(matBrojL + ": " + matBroj, fdt, 0x1000000));
        GridPrint gpMiddle = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175)});
        gpMiddle.setLook((GridLook)dgl);
        gpMiddle.add((Print)new TextPrint(bankaL + ": " + banka, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(racunL + ": " + racun, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(uPDVL + ": " + uPDV, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(delatnostL + ": " + delatnost, fdt, 0x1000000));
        GridPrint gpRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 250, 250)});
        gpRight.setLook((GridLook)dgl);
        gpRight.add((Print)new TextPrint(telL + ": " + tel, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(faxL + ": " + fax, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(web, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(email, fdt, 0x1000000));
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(new RGB(64, 64, 64));
        gpCompany.add((Print)lp, -1);
        gpCompany.add((Print)gpLeft);
        gpCompany.add((Print)gpMiddle);
        gpCompany.add((Print)gpRight);
        gpCompany.add((Print)lp, -1);
        String comment = "Dokument \u0161tampan: " + StatLogic.getDateTimeString(new Date()) + " iz programa \"Barmaster\" autor 5.com.d.o.o. - www.petcom.rs - Software for Business and Pleasure";
        gpCompany.add(16384, (Print)new TextPrint(comment, fdc), -1);
        return gpCompany;
    }

    public static GridPrint makePageFooter(FooterData footData) {
        String preduzece = footData.getPreduzece();
        String adresa = footData.getAdresa();
        String pib = footData.getPib();
        String matBroj = footData.getMatBroj();
        String banka = footData.getBanka();
        String racun = footData.getRacunBroj();
        String uPDV = footData.getuPDV();
        String delatnost = footData.getDelatnost();
        String tel = footData.getTel();
        String fax = footData.getFax();
        String web = footData.getWeb();
        String email = footData.getEmail();
        String preduzeceL = "Preduze\u0107e";
        String adresaL = "Adresa";
        String pibL = "PIB";
        String matBrojL = "Mat. Broj";
        String bankaL = "Banka";
        String racunL = "Ra\u010dun";
        String uPDVL = "U sistemu PDV";
        String delatnostL = "\u0160ifra delstnosti";
        String telL = "Tel";
        String faxL = "Fax";
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdc = new FontData(fontName, 5, 2);
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(1, 1);
        GridPrint gpCompany = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175), new GridColumn(0x1000000, 175, 175), new GridColumn(0x1000000, 250, 250)});
        gpCompany.setLook((GridLook)dgl);
        GridPrint gpLeft = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175)});
        gpLeft.setLook((GridLook)dgl);
        gpLeft.add((Print)new TextPrint(preduzeceL + ": " + preduzece, fdtb, 0x1000000));
        gpLeft.add((Print)new TextPrint(adresaL + ": " + adresa, fdt, 0x1000000));
        gpLeft.add((Print)new TextPrint(pibL + ": " + pib, fdt, 0x1000000));
        gpLeft.add((Print)new TextPrint(matBrojL + ": " + matBroj, fdt, 0x1000000));
        GridPrint gpMiddle = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 175, 175)});
        gpMiddle.setLook((GridLook)dgl);
        gpMiddle.add((Print)new TextPrint(bankaL + ": " + banka, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(racunL + ": " + racun, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(uPDVL + ": " + uPDV, fdt, 0x1000000));
        gpMiddle.add((Print)new TextPrint(delatnostL + ": " + delatnost, fdt, 0x1000000));
        GridPrint gpRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 250, 250)});
        gpRight.setLook((GridLook)dgl);
        gpRight.add((Print)new TextPrint(telL + ": " + tel, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(faxL + ": " + fax, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(web, fdt, 0x1000000));
        gpRight.add((Print)new TextPrint(email, fdt, 0x1000000));
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(new RGB(64, 64, 64));
        gpCompany.add((Print)lp, -1);
        gpCompany.add((Print)gpLeft);
        gpCompany.add((Print)gpMiddle);
        gpCompany.add((Print)gpRight);
        gpCompany.add((Print)lp, -1);
        String comment = "Dokument \u0161tampan: " + StatLogic.getDateTimeString(new Date()) + " iz programa \"Barmaster\" autor 5.com.d.o.o. - www.petcom.rs - Software for Business and Pleasure";
        gpCompany.add(16384, (Print)new TextPrint(comment, fdc), -1);
        return gpCompany;
    }

    public static Print makeTaxes(List<StavkaRacuna> lsr) {
        HashMap<PoreskaGrupa, Object> mapaPoreza = new HashMap<PoreskaGrupa, Object>();
        HashMap<PoreskaGrupa, Double> mapaOsnovica = new HashMap<PoreskaGrupa, Double>();
        Double porezUkupno = 0.0;
        Double osnovicaUkupno = 0.0;
        for (StavkaRacuna sr : lsr) {
            Double total;
            PoreskaGrupa pg = sr.getArtikal().getPoreskaGrupa();
            Double osnovica = 0.0;
            PoreskaGrupa[] porez = Double.valueOf(0.0);
            Double vrednost = sr.getVrednostSaPopustom();
            Double stopa = Konstante.getPdvPoPG(pg);
            osnovica = vrednost / (1.0 + stopa);
            porez = osnovica * stopa;
            if (mapaPoreza.containsKey(pg)) {
                total = (Double)mapaPoreza.get(pg);
                total = total + porez.doubleValue();
                mapaPoreza.put(pg, total);
            } else {
                mapaPoreza.put(pg, porez);
            }
            if (mapaOsnovica.containsKey(pg)) {
                total = (Double)mapaOsnovica.get(pg);
                total = total + osnovica;
                mapaOsnovica.put(pg, total);
            } else {
                mapaOsnovica.put(pg, osnovica);
            }
            porezUkupno = porezUkupno + porez.doubleValue();
            osnovicaUkupno = osnovicaUkupno + osnovica;
        }
        GridPrint taxTotal = new GridPrint(new GridColumn[]{new GridColumn(16384, 300, 300), new GridColumn(131072, 300, 300)});
        taxTotal.add((Print)new EmptyPrint(15, 15), -1);
        GridPrint tax = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 70, 0), new GridColumn(0x1000000, 90, 0), new GridColumn(0x1000000, 90, 0)});
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        tax.addHeader(16384, (Print)new TextPrint("Rekapitulacija poreza", fdt, 0x1000000), -1);
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        tax.addHeader((Print)new TextPrint("Stopa", fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint("Osnovica", fdt, 0x1000000));
        tax.addHeader((Print)new TextPrint("Iznos poreza", fdt, 0x1000000));
        tax.addHeader((Print)new LinePrint(256, 1.0), -1);
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (!mapaPoreza.containsKey(pg)) continue;
            tax.add((Print)new TextPrint(StatLogic.getNumber02(Konstante.getPdvPoPG(pg) * 100.0) + "%", fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaOsnovica.get(pg)), fdt, 0x1000000));
            tax.add((Print)new TextPrint(StatLogic.getNumber02((Double)mapaPoreza.get(pg)), fdt, 0x1000000));
        }
        tax.addFooter((Print)new LinePrint(256, 1.0), -1);
        tax.addFooter((Print)new EmptyPrint());
        tax.addFooter((Print)new TextPrint("Ukupno: ", fdtb, 0x1000000));
        tax.addFooter((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdtb, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)tax));
        GridPrint total = new GridPrint(new GridColumn[]{new GridColumn(131072, 160, 0), new GridColumn(131072, 90, 0)});
        FontData fdh = new FontData(fontName, headingSize, 0);
        FontData fdhPlus = new FontData(fontName, headingSize + 2, 1);
        total.add((Print)new LinePrint(256, 1.0), -1);
        total.add((Print)new TextPrint("Ukupno bez ura\u010dunatog PDV-a", fdh, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno), fdh, 0x1000000));
        total.add((Print)new TextPrint("Ukupan iznos PDV-a", fdh, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(porezUkupno), fdh, 0x1000000));
        total.add((Print)new LinePrint(256, 1.0), -1);
        total.add((Print)new TextPrint("ZA UPLATU:", fdhPlus, 0x1000000));
        total.add((Print)new TextPrint(StatLogic.getNumber02(osnovicaUkupno + porezUkupno), fdhPlus, 0x1000000));
        taxTotal.add((Print)new NoBreakPrint((Print)total));
        return taxTotal;
    }

    public static Print makePayments(List<Placanje> pList) {
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        GridPrint payments = new GridPrint(new GridColumn[]{new GridColumn(16384, 300, 300), new GridColumn(131072, 300, 300)});
        payments.add((Print)new EmptyPrint(15, 15), -1);
        payments.add((Print)new EmptyPrint());
        GridPrint payment = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 150, 0), new GridColumn(0x1000000, 100, 0)});
        payment.addHeader(16384, (Print)new TextPrint("Uplate:", fdt, 0x1000000), -1);
        payment.addHeader((Print)new LinePrint(256, 1.0), -1);
        payment.addHeader((Print)new TextPrint("Na\u010din pla\u0107anja", fdt, 0x1000000));
        payment.addHeader((Print)new TextPrint("Iznos", fdt, 0x1000000));
        payment.addHeader((Print)new LinePrint(256, 1.0), -1);
        for (Placanje p : pList) {
            payment.add((Print)new TextPrint(p.getNacin().name(), fdt, 0x1000000));
            payment.add((Print)new TextPrint(StatLogic.getNumber02(p.getIznos()), fdt, 0x1000000));
        }
        payment.addFooter((Print)new LinePrint(256, 1.0), -1);
        payment.addFooter((Print)new TextPrint("Ukupno: ", fdtb, 0x1000000));
        payment.addFooter((Print)new TextPrint(StatLogic.getNumber02(11590.0), fdtb, 0x1000000));
        payments.add((Print)new NoBreakPrint((Print)payment));
        return payments;
    }

    public static void printPreview(Print p, String title) {
        Display d = new Display();
        Shell s = new Shell(d, 1264);
        s.setText(title);
        s.setMaximized(true);
        s.setLayout((Layout)new GridLayout());
        ToolBar tb = new ToolBar((Composite)s, 0x800200);
        ToolItem tiNext = new ToolItem(tb, 8);
        tiNext.setText(">");
        tiNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        s.open();
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        d.dispose();
    }

    public static class FooterData {
        private String preduzece;
        private String adresa;
        private String pib;
        private String matBroj;
        private String banka;
        private String racunBroj;
        private String uPDV;
        private String delatnost;
        private String tel;
        private String fax;
        private String web;
        private String email;

        public FooterData() {
            this.preduzece = "";
            this.adresa = "";
            this.pib = "";
            this.matBroj = "";
            this.banka = "";
            this.racunBroj = "";
            this.uPDV = "";
            this.delatnost = "";
            this.tel = "";
            this.fax = "";
            this.web = "";
            this.email = "";
        }

        public FooterData(boolean testData) {
            this.preduzece = "Monstrumanija k.a.o.";
            this.adresa = "Tri lipe 4, Krajolik Bo\u017eanstven";
            this.pib = "123456789";
            this.matBroj = "12345678";
            this.banka = "Dafiment banka";
            this.racunBroj = "d\u017eabe kad je prazan";
            this.uPDV = "DA";
            this.delatnost = "00000";
            this.tel = "0117654321";
            this.fax = "0111234567";
            this.web = "www.monstrumani.ja";
            this.email = "zalopoj@monstrumani.ja";
        }

        public String getPreduzece() {
            return this.preduzece;
        }

        public void setPreduzece(String preduzece) {
            this.preduzece = preduzece;
        }

        public String getAdresa() {
            return this.adresa;
        }

        public void setAdresa(String adresa) {
            this.adresa = adresa;
        }

        public String getPib() {
            return this.pib;
        }

        public void setPib(String pib) {
            this.pib = pib;
        }

        public String getMatBroj() {
            return this.matBroj;
        }

        public void setMatBroj(String matBroj) {
            this.matBroj = matBroj;
        }

        public String getBanka() {
            return this.banka;
        }

        public void setBanka(String banka) {
            this.banka = banka;
        }

        public String getRacunBroj() {
            return this.racunBroj;
        }

        public void setRacunBroj(String racunBroj) {
            this.racunBroj = racunBroj;
        }

        public String getuPDV() {
            return this.uPDV;
        }

        public void setuPDV(String uPDV) {
            this.uPDV = uPDV;
        }

        public String getDelatnost() {
            return this.delatnost;
        }

        public void setDelatnost(String delatnost) {
            this.delatnost = delatnost;
        }

        public String getTel() {
            return this.tel;
        }

        public void setTel(String tel) {
            this.tel = tel;
        }

        public String getFax() {
            return this.fax;
        }

        public void setFax(String fax) {
            this.fax = fax;
        }

        public String getWeb() {
            return this.web;
        }

        public void setWeb(String web) {
            this.web = web;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    public static class HeaderData {
        private int brRacuna = 0;
        private Date datumIzdavanja = new Date();
        private Date datumPrometa = new Date();
        private Date datumValute;
        private String mestoIzdavanja;
        private String mestoPrometa;
        private String nazivKupca;
        private String adresaKupca;
        private String pibKupca;

        public HeaderData() {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "";
            this.mestoPrometa = "";
            this.nazivKupca = "";
            this.adresaKupca = "";
            this.pibKupca = "";
        }

        public HeaderData(boolean test) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.datumValute = cal.getTime();
            this.mestoIzdavanja = "Beograd";
            this.mestoPrometa = "Beograd";
            this.nazivKupca = "Metaloglo\u0111a\u010dica d.o.o.";
            this.adresaKupca = "Kingdom of FarFarAway, FarFarAway u.p.m.";
            this.pibKupca = "123456789";
        }

        public int getBrRacuna() {
            return this.brRacuna;
        }

        public void setBrRacuna(int brRacuna) {
            this.brRacuna = brRacuna;
        }

        public Date getDatumIzdavanja() {
            return this.datumIzdavanja;
        }

        public void setDatumIzdavanja(Date datumIzdavanja) {
            this.datumIzdavanja = datumIzdavanja;
        }

        public Date getDatumPrometa() {
            return this.datumPrometa;
        }

        public void setDatumPrometa(Date datumPrometa) {
            this.datumPrometa = datumPrometa;
        }

        public Date getDatumValute() {
            return this.datumValute;
        }

        public void setDatumValute(Date datumValute) {
            this.datumValute = datumValute;
        }

        public String getMestoIzdavanja() {
            return this.mestoIzdavanja;
        }

        public void setMestoIzdavanja(String mestoIzdavanja) {
            this.mestoIzdavanja = mestoIzdavanja;
        }

        public String getMestoPrometa() {
            return this.mestoPrometa;
        }

        public void setMestoPrometa(String mestoPrometa) {
            this.mestoPrometa = mestoPrometa;
        }

        public String getNazivKupca() {
            return this.nazivKupca;
        }

        public void setNazivKupca(String nazivKupca) {
            this.nazivKupca = nazivKupca;
        }

        public String getAdresaKupca() {
            return this.adresaKupca;
        }

        public void setAdresaKupca(String adresaKupca) {
            this.adresaKupca = adresaKupca;
        }

        public String getPibKupca() {
            return this.pibKupca;
        }

        public void setPibKupca(String pibKupca) {
            this.pibKupca = pibKupca;
        }
    }
}

