/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.tax;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.tax.TaxGroup;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class TaxGroupConverter {
    private static final Map<TaxGroup, PoreskaGrupa> TG_PG_MAP;
    private static final Map<PoreskaGrupa, TaxGroup> PG_TG_MAP;

    public static PoreskaGrupa from(TaxGroup tg) {
        return TG_PG_MAP.get((Object)tg);
    }

    public static TaxGroup to(PoreskaGrupa pg) {
        return PG_TG_MAP.get(pg);
    }

    static {
        PG_TG_MAP = Arrays.stream(PoreskaGrupa.values()).collect(Collectors.collectingAndThen(Collectors.toMap(pg -> pg, pg -> TaxGroup.values()[pg.ordinal()]), Collections::unmodifiableMap));
        TG_PG_MAP = PG_TG_MAP.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey), Collections::unmodifiableMap));
    }
}

