/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.tax;

import com.dev63.restoran.tax.TaxControl;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TaxControlDefault
implements TaxControl {
    private static final int MONEY_SCALE = 2;

    @Override
    public BigDecimal nettoFromBrutto(BigDecimal brutto, BigDecimal rate) {
        return brutto.divide(BigDecimal.ONE.add(rate), 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal taxFromBrutto(BigDecimal brutto, BigDecimal rate) {
        return brutto.subtract(this.nettoFromBrutto(brutto, rate)).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal taxFromNetto(BigDecimal netto, BigDecimal rate) {
        return netto.multiply(rate).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal bruttoFromNetto(BigDecimal netto, BigDecimal rate) {
        return netto.add(this.taxFromNetto(netto, rate)).setScale(2, RoundingMode.HALF_UP);
    }
}

