/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.resources;

import com.dev63.restoran.BMTerminalSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static HashMap<String, Image> imageMap;
    private static final String ICON_ROOT_PATH;

    public static Image getImage(String fileName) {
        fileName = ICON_ROOT_PATH + fileName;
        Image image = imageMap.get(fileName);
        if (image == null || image.isDisposed()) {
            image = ImageCache.createImage(fileName);
            imageMap.put(fileName, image);
        }
        return image;
    }

    public static ImageData getImageData(String fileName) {
        Image image;
        fileName = ICON_ROOT_PATH + fileName;
        ImageData imgDat = null;
        if (imageMap.containsKey(fileName) && (image = imageMap.get(fileName)) != null) {
            return image.getImageData();
        }
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        try {
            imgDat = new ImageData(is);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return imgDat;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        Image img = new Image((Device)Display.getCurrent(), is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return img;
    }

    public static void dispose() {
        for (Image i : imageMap.values()) {
            if (i == null || i.isDisposed()) continue;
            i.dispose();
        }
    }

    static {
        ICON_ROOT_PATH = BMTerminalSettings.getFOTheme().getResourcePath();
        imageMap = new HashMap();
    }
}

