/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.extensions.labelproviders;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.newmodel.OrderItem;
import java.math.BigDecimal;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractTableSplitListViewLabelProvider
extends LabelProvider {
    public Image getImage(Object o) {
        return null;
    }

    public String getText(Object o) {
        StringBuilder label = new StringBuilder();
        if (o instanceof Tura) {
            Tura tura = (Tura)o;
            label.append(" ").append(String.format(Konstante.getBundle().getString("TEXT_PORUDZBINA_BROJ"), new Object[0])).append(" ").append(tura.getBrojTure());
        } else if (o instanceof OrderItem) {
            OrderItem item = (OrderItem)o;
            if (item.getParentItem() != null) {
                label.append("   +");
            }
            label.append("   -").append(this.getQuantityDisplay(item)).append("x ").append(item.getName()).append("  ").append(StatLogic.getNumber02(this.getQuantity(item).multiply(item.getPrice())));
        } else if (o instanceof String) {
            String s = (String)o;
            label.append(s);
        }
        return label.toString();
    }

    private String getQuantityDisplay(OrderItem item) {
        if (item.getParentItem() != null) {
            return String.format("(%1$sx)%2$s", this.getItemQuantityDisplay((OrderItem)item.getParentItem()), StatLogic.getNumber03NGF(item.getQuantity().divide(item.getParentItem().getQuantity(), 6, 4)));
        }
        return this.getItemQuantityDisplay(item);
    }

    private String getItemQuantityDisplay(OrderItem item) {
        return StatLogic.getNumber03NGF(this.getQuantity(item));
    }

    protected abstract BigDecimal getQuantity(OrderItem var1);
}

