/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.extensions.contentproviders;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.comparators.MasterComparators;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class TableSplitListViewContentProvider
implements IStructuredContentProvider {
    private final String totalFormat = Konstante.getBundle().getString("TEXT_UKUPNO").concat(": %s");
    private double sum = 0.0;

    public double getSum() {
        return this.sum;
    }

    protected abstract double getValue(StavkaRacuna var1);

    public Object[] getElements(Object o) {
        this.sum = 0.0;
        Map mapa = null;
        if (o instanceof Map) {
            try {
                mapa = (Map)o;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (mapa == null) {
            return new Object[0];
        }
        return this.extractContent(mapa).toArray();
    }

    private Stream<Object> entryToStream(Map.Entry<Tura, Collection<StavkaRacuna>> entry) {
        LinkedList<BObject> res = new LinkedList<BObject>();
        res.add(entry.getKey());
        res.addAll(this.items(entry));
        return (Stream)res.stream().sequential();
    }

    protected List<Object> extractContent(Map<Tura, Collection<StavkaRacuna>> map) {
        List items = map.entrySet().stream().sorted(Comparator.comparing(e -> (Tura)e.getKey(), MasterComparators.ORDER_NUMBER_COMPARATOR)).flatMap(this::entryToStream).collect(Collectors.toList());
        ArrayList<Object> res = new ArrayList<Object>(items.size() + 2);
        res.addAll(items);
        res.add("");
        res.add(String.format(this.totalFormat, StatLogic.getNumber02(this.sum)));
        return res;
    }

    protected List<StavkaRacuna> items(Map.Entry<Tura, Collection<StavkaRacuna>> entry) {
        return this.explodedItems(entry.getValue());
    }

    protected List<StavkaRacuna> explodedItems(Collection<StavkaRacuna> items) {
        return items.stream().sorted(MasterComparators.ITEM_ID_COMPARATOR).flatMap(i -> {
            LinkedList<StavkaRacuna> res = new LinkedList<StavkaRacuna>();
            res.add((StavkaRacuna)i);
            res.addAll(i.getPodStavke() == null ? Collections.emptyList() : i.getPodStavke());
            return res.stream();
        }).peek(i -> this.sum += this.getValue((StavkaRacuna)i)).collect(Collectors.toList());
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object o, Object o1) {
    }
}

