/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.components;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.swt.components.ImageButton;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledStavkeRacuna
implements Runnable {
    Display display = null;
    public static Shell sh;
    private Color belo;
    private Rectangle bounds;
    Racun racun;
    RestoranServer server;

    public PregledStavkeRacuna(final Racun racun, final RestoranServer server) {
        this.racun = racun;
        this.server = server;
        sh = new Shell(67680);
        this.display = sh.getDisplay();
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        Color buttCol = new Color((Device)sh.getDisplay(), BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.belo = this.display.getSystemColor(1);
        GridLayout gl = new GridLayout(1, true);
        sh.setBackgroundMode(1);
        int x = this.bounds.width / 2 - 200;
        int y = (this.bounds.height - 400) / 4;
        sh.setLocation(x, y);
        sh.setBackground(this.belo);
        sh.setLayout((Layout)gl);
        Composite m = new Composite((Composite)sh, 2048);
        GridData g = new GridData(4, 4, true, true);
        m.setLayoutData((Object)g);
        m.setLayout((Layout)new GridLayout(1, true));
        GridData gdm = new GridData(4, 4, true, false);
        Label l = new Label(m, 0);
        l.setBackground(this.belo);
        l.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 75, 0));
        l.setText(String.format(Konstante.getBundle().getString("TEXT_STAVKE_RACUNA_BROJ"), new Object[0]) + ": " + racun.getBrojRacuna());
        l.setLayoutData((Object)gdm);
        Label l1 = new Label(m, 0);
        l1.setBackground(this.belo);
        l1.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 75, 0));
        l1.setText(String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0]) + ": " + racun.getKonobar().getPunoime());
        l1.setLayoutData((Object)gdm);
        final Table table = new Table((Composite)sh, 512);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        GridData data = new GridData(-1, 400);
        table.setLayoutData((Object)data);
        TableColumn tc0 = new TableColumn(table, 0x1000000);
        tc0.setText(String.format(Konstante.getBundle().getString("TEXT_STAVKE_RACUNA"), new Object[0]));
        tc0.setWidth(200);
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_CENA"), new Object[0]));
        tc1.setWidth(80);
        TableItem ti = null;
        double ukupno = 0.0;
        for (StavkaRacuna sr : StavkeSumarno.getSumarnoPopust(server.getStavke(racun.getId()))) {
            int i = 0;
            ti = new TableItem(table, 0);
            if (!sr.getArtikal().getDozvoljenPopust().booleanValue()) {
                ti.setForeground(sh.getDisplay().getSystemColor(9));
            }
            ti.setText(i++, Konstante.getNumber14(sr.getKolicina()) + "x " + sr.getNaziv() + "(" + sr.getCena() + ")");
            double cena = sr.getKolicina() * sr.getCena();
            ti.setText(i++, Konstante.getNumber14(cena));
            ukupno += cena;
        }
        ti = new TableItem(table, 0);
        ti.setText(new String[]{String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber14(ukupno)});
        ti.setFont(Konstante.getFont(sh.getDisplay(), 12, 1));
        Composite c = new Composite((Composite)sh, 2048);
        GridData gd = new GridData(4, 4, false, false);
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(768);
        gridData.heightHint = 25;
        ImageButton enter = new ImageButton(c, 524288);
        enter.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 90, 1));
        enter.setForeground(buttCol);
        enter.setText(String.format(Konstante.getBundle().getString("TEXT_OK"), new Object[0]));
        enter.setLayoutData(gridData);
        enter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                sh.close();
            }
        });
        ImageButton stampa = new ImageButton(c, 524288);
        stampa.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 90, 1));
        stampa.setForeground(buttCol);
        stampa.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        stampa.setLayoutData(gridData);
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(table), false, true, String.format(Konstante.getBundle().getString("TEXT_STAVKE_RACUNA_BROJ"), new Object[0]) + racun.getBrojRacuna(), sh, server);
            }
        });
        sh.open();
        sh.pack();
        while (!sh.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public void run() {
        new PregledStavkeRacuna(this.racun, this.server);
    }
}

