/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.swt.components;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.AdministracijaPopusta;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class DiscountController
implements Runnable {
    Display display = null;
    protected static Shell sh;
    private Color pozadina;
    private Color svCrno;
    private Color tamnoSivo;
    private Color belo;
    private Rectangle bounds;
    private AdministracijaPopusta popust = null;
    RestoranServer server;

    public DiscountController(RestoranServer server) {
        sh = new Shell(65536);
        this.display = sh.getDisplay();
        this.server = server;
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        boolean crnaTema = BMTerminalSettings.getSetting(OptionBO.CRNA_TEMA).booleanValue();
        this.pozadina = new Color((Device)this.display, 115, 119, 128);
        this.svCrno = new Color((Device)this.display, 34, 37, 46);
        this.tamnoSivo = new Color((Device)this.display, 49, 53, 64);
        this.belo = this.display.getSystemColor(1);
        GridLayout gl = new GridLayout(1, true);
        sh.setBackgroundMode(1);
        int x = this.bounds.width / 2 - 160;
        int y = this.bounds.height / 2 - 120;
        sh.setLocation(x, y);
        sh.setBackground(crnaTema ? this.pozadina : this.belo);
        sh.setLayout((Layout)gl);
        Composite m = new Composite((Composite)sh, 2048);
        GridData g = new GridData(4, 4, true, true);
        m.setLayoutData((Object)g);
        m.setLayout((Layout)new GridLayout(1, true));
        GridData gdm = new GridData(4, 4, true, false);
        Label l = new Label(m, 0);
        l.setBackground(this.belo);
        l.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 75, 0));
        l.setText("Odaberite direktni popust: ");
        l.setLayoutData((Object)gdm);
        gdm.heightHint = this.bounds.height / 50;
        Composite c = new Composite((Composite)sh, 2048);
        GridData gd = new GridData(4, 4, false, false);
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(6, false));
        Color buttCol = new Color((Device)sh.getDisplay(), BMTerminalSettings.getFOTheme().getHeaderFontColor());
        sh.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)buttCol));
        Font numFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getNumButtonFont());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 165;
        gridData.heightHint = 80;
        List<AdministracijaPopusta> listaPopusta = server.readAdministracijaPopusti();
        for (final AdministracijaPopusta ap : listaPopusta) {
            ImageButton bBS = new ImageButton(c, 524288);
            bBS.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 70, 1));
            bBS.setForeground(buttCol);
            bBS.setText(ap.getNaziv());
            bBS.setLayoutData(gridData);
            bBS.setData(ap);
            bBS.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    DiscountController.this.popust = ap;
                    sh.close();
                }
            });
        }
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.widthHint = 520;
        gridData.heightHint = 80;
        ImageButton enter = new ImageButton(c, 524288);
        enter.setFont(new Font((Device)this.display, "Klavika Md", this.bounds.height / 45, 1));
        enter.setForeground(buttCol);
        enter.setText("Izadji bez popusta");
        enter.setLayoutData(gridData);
        enter.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                sh.close();
            }
        });
        sh.open();
        sh.pack();
        while (!sh.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public AdministracijaPopusta jePopust() {
        return this.popust;
    }

    public void addListenerTastatura(String s, Control b) {
        b.addListener(3, new Listener(){

            public void handleEvent(Event e) {
            }
        });
    }

    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void run() {
        new DiscountController(this.server);
    }
}

