/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Otpis;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class UskaStampa {
    File print;
    RestoranServer server;
    Stampac stampac;
    String content = "";

    public UskaStampa(Object o, Restoran restoran) {
        this.server = restoran.getServer();
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            if (this.stampac == null) {
                return;
            }
            switch (this.stampac.getTip()) {
                case EPSONTMT: {
                    this.writeInFile(o, 4);
                    break;
                }
                case EPSONTMT80: {
                    this.writeInFile(o, 4);
                    break;
                }
                case EPP: {
                    this.writeInFile(o, 8);
                    break;
                }
                default: {
                    this.writeInFile(o, 0);
                }
            }
            this.printFromFile();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private void writeInFile(Object o, int extraLinija) {
        if (o instanceof Prijemnica) {
            Prijemnica prijemnica = (Prijemnica)o;
            try {
                this.content = this.content + StringUtils.center((String)Konstante.getDate(prijemnica.getDatumPrijemnice()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Prijemnica broj: " + prijemnica.getBrPrijemnice()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Opis: " + prijemnica.getOpis()), (int)34) + "\n\n";
                this.content = this.content + StringUtils.left((String)"ARTIKAL", (int)34) + "\n";
                this.content = this.content + "KOLICINA x Cena po JM        TOTAL\n";
                this.content = this.content + "----------------------------------\n";
                double total = 0.0;
                for (PrijemnicaStavka stavka : this.server.readStavkePrijemnice(prijemnica)) {
                    total += stavka.getVrednost().doubleValue();
                    this.content = this.content + new StringAlign(34, 108).format(stavka.getArtikal().getName()) + "\n";
                    this.content = this.content + new StringAlign(8, 99).format(Konstante.getNumber02(stavka.getKolicina())) + new StringAlign(3, 99).format("x") + new StringAlign(10, 99).format(Konstante.getNumber02(stavka.getKomad())) + new StringAlign(2, 99).format("  ") + new StringAlign(11, 114).format(Konstante.getNumber2(stavka.getVrednost())) + "\n";
                }
                this.content = this.content + "                       -----------\n";
                this.content = this.content + "                 TOTAL:" + new StringAlign(11, 114).format(Konstante.getNumber2(total)) + "\n";
                this.content = this.content + "----------------------------------\n";
            }
            catch (Exception ex) {
                Logger.getLogger(UskaStampa.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (o instanceof Trebovanje) {
            Trebovanje trebovanje = (Trebovanje)o;
            try {
                this.content = this.content + StringUtils.center((String)Konstante.getDate(trebovanje.getDatumTrebovanja()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Odeljenje: " + trebovanje.getU().getNaziv()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Trebovanje broj: " + trebovanje.getBrTrebovanja()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Opis: " + trebovanje.getOpis()), (int)34) + "\n\n";
                this.content = this.content + new StringAlign(26, 108).format("ARTIKAL") + new StringAlign(8, 114).format("KOLICINA") + "\n";
                this.content = this.content + "----------------------------------\n";
                for (TrebovanjeStavka stavka : this.server.readStavkeTrebovanja(trebovanje)) {
                    this.content = this.content + new StringAlign(28, 108).format(stavka.getArtikal().getName()) + new StringAlign(6, 114).format(Konstante.getNumber02(stavka.getKolicina())) + "\n";
                }
                this.content = this.content + "----------------------------------\n";
            }
            catch (Exception ex) {
                Logger.getLogger(UskaStampa.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (o instanceof Otpis) {
            Otpis otpis = (Otpis)o;
            try {
                this.content = this.content + StringUtils.center((String)Konstante.getDate(otpis.getDatum()), (int)34) + "\n";
                this.content = this.content + StringUtils.center((String)"OTPIS", (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Odeljenje: " + otpis.getOdeljenje().getNaziv()), (int)34) + "\n";
                this.content = this.content + StringUtils.left((String)("Opis: " + otpis.getOpis()), (int)34) + "\n\n";
                this.content = this.content + StringUtils.left((String)"ARTIKAL", (int)34) + "\n";
                this.content = this.content + "             KOMADA       VREDNOST\n";
                this.content = this.content + "----------------------------------\n";
                for (OtpisStavka stavka : this.server.readStavkeOtpisa(otpis)) {
                    this.content = this.content + new StringAlign(34, 108).format(stavka.getArtikal().getName()) + "\n";
                    this.content = this.content + new StringAlign(12, 99).format("") + new StringAlign(8, 99).format(Konstante.getNumber02(stavka.getKolicina())) + new StringAlign(3, 99).format("   ") + new StringAlign(11, 114).format(Konstante.getNumber2(stavka.getVrednost())) + "\n";
                }
                this.content = this.content + "                       -----------\n";
                this.content = this.content + "                 TOTAL:" + new StringAlign(11, 114).format(Konstante.getNumber2(otpis.getVrednost())) + "\n";
                this.content = this.content + "----------------------------------\n";
            }
            catch (Exception ex) {
                Logger.getLogger(UskaStampa.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void printFromFile() {
        try {
            byte[] out;
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
            }
            byte[] temp = this.content.getBytes();
            switch (this.stampac.getTip()) {
                case STARTCP100: {
                    out = new byte[temp.length + 3];
                    System.arraycopy(temp, 0, out, 0, temp.length);
                    out[out.length - 3] = 27;
                    out[out.length - 2] = 100;
                    out[out.length - 1] = 51;
                    break;
                }
                default: {
                    out = new byte[temp.length + 2];
                    System.arraycopy(temp, 0, out, 0, temp.length);
                    out[out.length - 2] = 27;
                    out[out.length - 1] = 105;
                }
            }
            ByteArrayInputStream is = new ByteArrayInputStream(out);
            SimpleDoc doc = new SimpleDoc(is, flavor, null);
            pj.print(doc, aset);
            ((InputStream)is).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

