/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.NPrintUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UskaPrometPoArtiklima {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    static List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    static int totalPodgrupe;
    List<GrupaArtikala> grupe = new ArrayList<GrupaArtikala>();
    List<String> crnaPlacanja;
    Map<PodgrupaArtikala, Double> mapaPG = new HashMap<PodgrupaArtikala, Double>();
    Map<GrupaArtikala, Double> mapaP = new HashMap<GrupaArtikala, Double>();
    Map<NacinPlacanja, Double> nacinP;
    Map<String, Double> nacinPCrno;
    List<StavkaRacuna> stavke;
    Date day1;
    Date day2;
    boolean crno;
    List<StavkaRacuna> stavkeKonacno = new ArrayList<StavkaRacuna>();
    Odeljenje odeljenje;
    Button printButton4;
    double medjuzbir = 0.0;

    public UskaPrometPoArtiklima(Shell sh, Restoran re, Odeljenje od, boolean be, boolean cr) {
        double d;
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.shell = sh;
        this.crno = cr;
        this.nacinP = new HashMap<NacinPlacanja, Double>();
        this.day1 = this.server.getPoslednjiPocetni();
        this.day2 = Konstante.getKrajnjiDatum(new Date(), this.server);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(6, false));
        if (be) {
            for (NacinPlacanja np : NacinPlacanja.values()) {
                this.nacinP.put(np, 0.0);
            }
        }
        if (this.crno) {
            this.crnaPlacanja = new ArrayList<String>();
            for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                this.crnaPlacanja.add(cp.getNaziv());
            }
        }
        this.odeljenje = od;
        if (this.crno) {
            this.stavke = this.server.getSveStavke(this.day1, this.day2, this.odeljenje);
            block8: for (StavkaRacuna sr : this.stavke) {
                if (sr.getRacun().getCrnoPlacanje() == null) continue;
                for (String st : this.crnaPlacanja) {
                    if (!st.equals(sr.getRacun().getCrnoPlacanje())) continue;
                    this.stavkeKonacno.add(sr);
                    continue block8;
                }
            }
            this.nacinPCrno = this.makeMapCrno();
        } else if (be) {
            this.stavke = this.server.getStavke(this.day1, this.day2, this.odeljenje);
        }
        if (be) {
            for (StavkaRacuna sr : this.stavke) {
                if (sr.getRacun().getCrnoPlacanje() != null) continue;
                this.stavkeKonacno.add(sr);
            }
        }
        ArrayList<Racun> racuni = new ArrayList<Racun>();
        for (StavkaRacuna a : this.stavkeKonacno) {
            if (this.odeljenje != null || racuni.contains(a.getRacun())) continue;
            racuni.add(a.getRacun());
        }
        if (this.odeljenje == null) {
            for (Racun r : racuni) {
                if (!this.crno && be) {
                    for (Placanje p : r.getPlacanja()) {
                        d = this.nacinP.get((Object)p.getNacin());
                        this.nacinP.put(p.getNacin(), p.getIznos() + d);
                    }
                    continue;
                }
                if (r.getCrnoPlacanje() != null) {
                    try {
                        double d2 = this.nacinPCrno.get(r.getCrnoPlacanje());
                        this.nacinPCrno.put(r.getCrnoPlacanje(), d2 + r.total());
                    }
                    catch (Exception d2) {}
                    continue;
                }
                if (!be) continue;
                for (Placanje p : r.getPlacanja()) {
                    System.out.println(r.toString());
                    System.out.println((p.getNacin() == null) + " " + (this.nacinP == null));
                    d = this.nacinP.get((Object)p.getNacin());
                    this.nacinP.put(p.getNacin(), p.getIznos() + d);
                }
            }
        } else {
            for (StavkaRacuna sr : this.stavkeKonacno) {
                if (!this.crno && be) {
                    for (Placanje p : sr.getRacun().getPlacanja()) {
                        d = this.nacinP.get((Object)p.getNacin());
                        this.nacinP.put(p.getNacin(), sr.getVrednost() + d);
                    }
                    continue;
                }
                if (sr.getRacun().getCrnoPlacanje() != null) {
                    try {
                        double d3 = this.nacinPCrno.get(sr.getRacun().getCrnoPlacanje());
                        this.nacinPCrno.put(sr.getRacun().getCrnoPlacanje(), d3 + sr.getVrednost());
                    }
                    catch (Exception d3) {}
                    continue;
                }
                if (!be) continue;
                for (Placanje p : sr.getRacun().getPlacanja()) {
                    d = this.nacinP.get((Object)p.getNacin());
                    this.nacinP.put(p.getNacin(), sr.getVrednost() + d);
                }
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 6;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        try {
            Stampac stampac = this.server.readIzvestajiStampacObject();
            int bkur = Konstante.getTipStampaca() == 2 ? 32 : (stampac != null ? stampac.getTip().getBrojKarakteraURedu() : 32);
            Setting sett = this.server.getSetting(Option.PROMET_ART_HCP_CENE);
            char[] mla = new char[bkur];
            Arrays.fill(mla, '-');
            boolean stampaCena = sett == null ? false : sett.booleanValue();
            HashMap m = new HashMap();
            HashMap<Artikal, Map> mm = new HashMap<Artikal, Map>();
            for (StavkaRacuna ss : this.stavkeKonacno) {
                Map tmap;
                if (!mm.containsKey(ss.getArtikal())) {
                    mm.put(ss.getArtikal(), new HashMap());
                }
                if (!(tmap = (Map)mm.get(ss.getArtikal())).containsKey(ss.getCena())) {
                    tmap.put(ss.getCena(), 0.0);
                }
                tmap.put(ss.getCena(), (Double)tmap.get(ss.getCena()) + ss.getKolicina());
                mm.put(ss.getArtikal(), tmap);
            }
            String s = "";
            s = s + NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())) + "\n";
            s = s + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_PREGLED_PRODATIH_ARTIKALA_CAPS"), new Object[0])) + "\n";
            s = s + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateString(this.day1) + " " + String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateString(this.day2)) + "\n";
            s = s + NPrintUtils.leftText(19, String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0])) + NPrintUtils.rightText(bkur - 19, stampaCena ? String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + "/" + String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]) : String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
            s = s + new String(mla) + "\n";
            ArrayList<String> stv = new ArrayList<String>();
            LinkedList artList = new LinkedList(mm.keySet());
            Collections.sort(artList, new NameComparator());
            Double total = 0.0;
            for (Artikal a : artList) {
                Map mpCenKol = (Map)mm.get(a);
                if (stampaCena) {
                    LinkedList lcen = new LinkedList(mpCenKol.keySet());
                    Collections.sort(lcen);
                    for (Double cen : lcen) {
                        Double subTotal = cen * (Double)mpCenKol.get(cen);
                        total = total + subTotal;
                        stv.add(NPrintUtils.leftText(bkur, a.getName()) + "\n");
                        stv.add(NPrintUtils.rightText(bkur - 10 - 10, StatLogic.getNumber03F((Double)mpCenKol.get(cen)) + "x") + NPrintUtils.rightText(10, StatLogic.getNumber02(cen)) + NPrintUtils.rightText(10, StatLogic.getNumber02(subTotal)) + "\n");
                    }
                    continue;
                }
                Double kol = 0.0;
                for (Double cen : mpCenKol.keySet()) {
                    kol = kol + (Double)mpCenKol.get(cen);
                }
                stv.add(NPrintUtils.leftText(bkur - 6, a.getName()) + NPrintUtils.rightText(6, StatLogic.getNumber03F(kol)) + "\n");
            }
            if (stampaCena) {
                String tot = StatLogic.getNumber02(total);
                char[] ssm = new char[tot.length()];
                Arrays.fill(ssm, '-');
                stv.add(NPrintUtils.rightText(bkur, new String(ssm)));
                stv.add(NPrintUtils.rightText(bkur, tot));
            }
            for (String w : stv) {
                s = s + w;
            }
            s = s + new String(mla) + "\n";
            if (Konstante.getTipStampaca() == 2) {
                s = s.replace("\n", "");
                if (this.server.getCurrentCounter() != null) {
                    s = NPrintUtils.centerText(bkur, this.server.getCurrentCounter().getOznaka()) + s;
                }
                XMLWriterHCP.writeNonFiscal(s);
            } else {
                NPrintUtils.printContent(s, stampac, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            System.out.println(ex.getMessage());
        }
    }

    public void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Podgrupa");
        tc4.setWidth(200);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("Artikal");
        tc1.setWidth(170);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Kolicina");
        tc2.pack();
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Cena kom.");
        tc9.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Vrednost");
        tc3.setWidth(120);
        tc3.pack();
    }

    public void insertRows() {
        TableItem ti;
        boolean prikaz = false;
        for (PodgrupaArtikala pg : podgrupe) {
            for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                if (!a.getArtikal().getPodgrupa().equals(pg)) continue;
                prikaz = true;
                break;
            }
            if (!this.crno && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, pg.getNaziv());
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            }
            for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                if (!a.getArtikal().getPodgrupa().equals(pg)) continue;
                double kol = a.getKolicina();
                double cena = a.getCena();
                if (!this.crno && prikaz) {
                    String n = a.getArtikal().getName();
                    TableItem ti2 = new TableItem(this.table, 0);
                    ti2.setText(new String[]{"", n, Konstante.getNumber02(kol), Konstante.getNumber2(cena), Konstante.getNumber2(kol * cena)});
                }
                double d = this.mapaPG.get(pg);
                this.mapaPG.put(pg, d += kol * cena);
            }
            if (!this.crno && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(3, "Ukupno:");
                ti.setText(4, Konstante.getNumber2(this.mapaPG.get(pg)));
                ti = new TableItem(this.table, 0);
            }
            prikaz = false;
        }
        for (PodgrupaArtikala pg : podgrupe) {
            for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                if (!a.getArtikal().getPodgrupa().equals(pg)) continue;
                prikaz = true;
                break;
            }
            if (!this.crno && prikaz) {
                ti = new TableItem(this.table, 0);
                ti.setText(0, pg.getNaziv());
                ti.setText(4, Konstante.getNumber2(this.mapaPG.get(pg)));
            }
            prikaz = false;
        }
        TableItem ti3 = new TableItem(this.table, 0);
    }

    public Map makeMapCrno() {
        HashMap<String, Double> mapa = new HashMap<String, Double>();
        for (String cp : this.crnaPlacanja) {
            mapa.put(cp, 0.0);
        }
        return mapa;
    }

    private List<NacinPlacanja> getNacine(StavkaRacuna sr) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        for (Placanje p : sr.getRacun().getPlacanja()) {
            n.add(p.getNacin());
        }
        return n;
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

