/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.stampa.NPrintUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class UskaPopisBlanko {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public UskaPopisBlanko(Display display, Odeljenje o, RestoranServer server) {
        List<Object> odeljenja = new ArrayList<Odeljenje>();
        if (o != null) {
            odeljenja.add(o);
        } else {
            odeljenja = server.readOdeljenjeBezMag();
        }
        for (Odeljenje odeljenje : odeljenja) {
            try {
                Stampac stampac = server.readIzvestajiStampacObject();
                if (stampac == null) continue;
                int bkur = stampac.getTip().getBrojKarakteraURedu();
                char[] mla = new char[bkur];
                Arrays.fill(mla, '-');
                String content = NPrintUtils.centerText(bkur, StatLogic.getDateString(new Date())) + "\n";
                content = content + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_POPIS"), new Object[0]) + " - " + odeljenje.getNaziv()) + "\n\n";
                content = content + new String(mla) + "\n";
                content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]), String.format(this.barmasterText.getString("TEXT_STANJE"), new Object[0])) + "\n";
                content = content + new String(mla) + "\n";
                for (String sp : server.getArtikliBezSloz(odeljenje.getId()).keySet()) {
                    content = content + NPrintUtils.leftText(bkur - 6, sp) + NPrintUtils.rightText(6, "______") + "\n";
                }
                content = content + new String(mla) + "\n";
                for (int i = 0; i < stampac.getTip().getBrojDodatnihLinija(); ++i) {
                    content = content + new String(mla) + "\n";
                }
                NPrintUtils.printContent(content, stampac, 1);
            }
            catch (Exception ex) {
                Logger.getLogger(UskaPopisBlanko.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

