/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class StringAlign
extends Format {
    protected char paddingChar = (char)32;
    public static final int JUST_LEFT = 108;
    public static final int JUST_CENTRE = 99;
    public static final int JUST_CENTER = 99;
    public static final int JUST_RIGHT = 114;
    private int just;
    private int maxChars;

    public StringAlign(int maxChars, int just) {
        switch (just) {
            case 99: 
            case 108: 
            case 114: {
                this.just = just;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid justification arg.");
            }
        }
        if (maxChars < 0) {
            throw new IllegalArgumentException("maxChars must be positive.");
        }
        this.maxChars = maxChars;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer where, FieldPosition ignore) {
        String s = (String)obj;
        String wanted = s.substring(0, Math.min(s.length(), this.maxChars));
        switch (this.just) {
            case 114: {
                this.pad(where, this.maxChars - wanted.length());
                where.append(wanted);
                break;
            }
            case 99: {
                int toAdd = this.maxChars - wanted.length();
                this.pad(where, toAdd / 2);
                where.append(wanted);
                this.pad(where, toAdd - toAdd / 2);
                break;
            }
            case 108: {
                where.append(wanted);
                this.pad(where, this.maxChars - wanted.length());
            }
        }
        return where;
    }

    protected final void pad(StringBuffer to, int howMany) {
        for (int i = 0; i < howMany; ++i) {
            to.append(this.paddingChar);
        }
    }

    String format(String s) {
        return this.format(s, new StringBuffer(), null).toString();
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return source;
    }
}

