/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StampaTrebovanjaSaKalkulacijom {
    private final Restoran restoran;
    SWTContainer parent;
    Panel panel;
    Trebovanje trebovanje;
    double total = 0.0;
    Shell shell;
    boolean sifre;
    DecimalFormat df = new DecimalFormat("#.##");

    public StampaTrebovanjaSaKalkulacijom(SWTContainer owner, Trebovanje tr, Restoran r) {
        this.restoran = r;
        this.parent = owner;
        this.trebovanje = tr;
        this.shell = this.parent.getControl().getShell();
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        Document doc = new Document(false);
        this.makeHeader(doc);
        List<TrebovanjeStavka> stavke = this.restoran.getServer().readStavkeTrebovanja(this.trebovanje);
        for (TrebovanjeStavka ts : stavke) {
            try {
                this.total += ts.getVrednost().doubleValue();
            }
            catch (Exception e) {
                this.total = -1.0;
                break;
            }
        }
        if (stavke.size() > 0) {
            TrebovanjeTableModel model = new TrebovanjeTableModel(stavke);
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            TableColumn tc = new TableColumn("artikal", "Naziv artikla");
            tc.setWidth(50);
            list.add(tc);
            tc = new TableColumn("jm", "Jed. mere");
            tc.setWidth(15);
            list.add(tc);
            tc = new TableColumn("kol", "Kolicina");
            tc.setWidth(20);
            tc.setAlign("right");
            list.add(tc);
            tc = new TableColumn("ncbp", "Nabavna cena bez PDV");
            tc.setWidth(25);
            tc.setAlign("right");
            list.add(tc);
            tc = new TableColumn("kom", "Nabavna cena");
            tc.setWidth(25);
            tc.setAlign("right");
            list.add(tc);
            tc = new TableColumn("nvbp", "Nabavna vrednost bez PDV");
            tc.setWidth(25);
            tc.setAlign("right");
            list.add(tc);
            tc = new TableColumn("vred", "Nabavna vrednost");
            tc.setWidth(25);
            tc.setAlign("right");
            list.add(tc);
            Table table = new Table((TableModel)model, list);
            table.setHeaderBorder(true);
            doc.addElement((Element)table);
        }
        doc.addElement((Element)this.makePotpisFooter());
        this.restoran.getServer().refresh();
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(1150, 700);
        Composite composite = new Composite((Composite)this.shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError list) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        this.panel = new Panel(new BorderLayout()){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        frame.add((Component)Print.printPreview((Document)doc));
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeader(Document doc) {
        Block b = new Block();
        Block c = new Block("Tahoma", 16, false, true);
        c.addElement((Element)new Text("TREBOVANJE"));
        Center center = new Center((Element)c);
        center.setContentHeight(6);
        center.setContentWidth(50);
        b.addElement((Element)center);
        Block c22 = new Block("Tahoma", 10, false, false);
        String s1 = Konstante.getVrednostTrebovanja(this.restoran.getServer().readStavkeTrebovanja(this.trebovanje)) != 0.0 && this.trebovanje.getIz() == null ? "--> MAGACIN --> " : (this.trebovanje.getIz() != null ? this.trebovanje.getIz().getNaziv() + " -->" : "");
        String s2 = this.trebovanje.getU() != null ? this.trebovanje.getU().getNaziv() : "";
        c22.addElement((Element)new Text(s1 + s2));
        Center center2 = new Center((Element)c22);
        center2.setContentHeight(6);
        center2.setContentWidth(50);
        b.addElement((Element)center2);
        Split s = new Split();
        c = new Block("Tahoma", 12, false, false);
        Setting naziv = this.restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
        String text = "Naziv ugostiteljskog objekta: ";
        if (naziv == null) {
            Konstante.getPoruka(this.shell, "Naziv objekta nije podesen!");
            text = text + "";
        } else {
            text = text + naziv.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        Setting maticniBroj = this.restoran.getServer().getSetting(Option.OBJEKAT_MATICNI_BROJ);
        text = "Maticni broj: ";
        if (maticniBroj == null) {
            Konstante.getPoruka(this.shell, "Maticni broj objekta nije podesen!");
            text = text + "";
        } else {
            text = text + maticniBroj.stringValue();
        }
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b.addElement((Element)s);
        b.setBox(true);
        s = new Split();
        Block b2 = new Block();
        Block c2 = new Block("Tahoma", 12, false, false);
        String text2 = "Broj trebovanja: ";
        text2 = text2 + this.trebovanje.getBrTrebovanja();
        c2.addElement((Element)new Text(text2));
        s.setLeft((Element)c2);
        c2 = new Block("Tahoma", 12, false, false);
        text = "Dobavljac: ";
        text = this.trebovanje.getDobavljac() == null ? text + "" : text + this.trebovanje.getDobavljac().getNaziv();
        c2.addElement((Element)new Text(text));
        s.setRight((Element)c2);
        b2.addElement((Element)s);
        s = new Split();
        c = new Block("Tahoma", 12, false, false);
        text = "Datum trebovanja: " + Konstante.getDate(this.trebovanje.getDatumTrebovanja());
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        c = new Block("Tahoma", 12, false, false);
        text = "Datum unosa: " + Konstante.getDate(this.trebovanje.getDatumUnosa());
        c.addElement((Element)new Text(text));
        s.setRight((Element)c);
        b2.addElement((Element)s);
        s = new Split();
        c = new Block("Tahoma", 12, false, false);
        text = "Napomena: " + this.trebovanje.getOpis();
        c.addElement((Element)new Text(text));
        s.setLeft((Element)c);
        b2.addElement((Element)s);
        b.setPaddingBottom(3);
        b.setPaddingTop(3);
        b2.setPaddingBottom(3);
        b2.setPaddingTop(6);
        Block d = new Block();
        d.addElement((Element)b);
        d.addElement((Element)b2);
        d.setPaddingBottom(3);
        d.setPaddingTop(3);
        doc.addElement((Element)d);
        doc.setDefaultFooter();
    }

    public Block makePotpisFooter() {
        Split s = new Split();
        Block b7 = new Block("Tahoma", 10, false, false);
        String text = this.total != -1.0 ? "NABAVNA VREDNOST: " + Konstante.getNumber2(this.total) : "";
        b7.addElement((Element)new Text(text));
        s.setRight((Element)b7);
        b7.setPaddingTop(3);
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________________");
        b3.setTextAlign("left");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        b1.setPaddingTop(32);
        b2.setPaddingTop(32);
        b3.setPaddingTop(32);
        Block b4 = new Block("Odgovorna osoba");
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block("Kontrolor");
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        return b;
    }

    private class TrebovanjeTableModel
    extends AbstractTableModel {
        private List<TrebovanjeStavka> list;

        public TrebovanjeTableModel(List<TrebovanjeStavka> list) {
            this.list = list;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "artikal";
                }
                case 1: {
                    return "jm";
                }
                case 2: {
                    return "kol";
                }
                case 3: {
                    return "ncbp";
                }
                case 4: {
                    return "vred";
                }
                case 5: {
                    return "nvbp";
                }
                case 6: {
                    return "kom";
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String s;
            TrebovanjeStavka ps = this.list.get(rowIndex);
            String n = ps.getArtikal().getName();
            String string = s = ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : "";
            if (n.contains("&")) {
                n = n.replace("&", " ");
            }
            switch (columnIndex) {
                case 0: {
                    return StampaTrebovanjaSaKalkulacijom.this.sifre ? s + " (" + n + ")" : n;
                }
                case 1: {
                    return ps.getArtikal().getJedinicaMere();
                }
                case 2: {
                    return ps.getKolicina();
                }
                case 3: {
                    return ps.getKomad() != null ? StampaTrebovanjaSaKalkulacijom.this.df.format(ps.getVrednostBezPDV() / ps.getKolicina()) : "/";
                }
                case 4: {
                    return ps.getKomad() != null ? StampaTrebovanjaSaKalkulacijom.this.df.format(ps.getKomad()) : "/";
                }
                case 5: {
                    return ps.getVrednost() != null ? StampaTrebovanjaSaKalkulacijom.this.df.format(ps.getVrednostBezPDV()) : "/";
                }
                case 6: {
                    return ps.getVrednost() != null ? StampaTrebovanjaSaKalkulacijom.this.df.format(ps.getVrednost()) : "/";
                }
            }
            throw new ArrayIndexOutOfBoundsException("columnIndex: " + columnIndex);
        }

        public void setList(List<TrebovanjeStavka> list) {
            this.list = list;
        }

        public List<TrebovanjeStavka> getList() {
            return this.list;
        }
    }
}

