/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPrint;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StampaTrebovanjaNPC
extends PagePrint {
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont = new FontData(this.fontName, 6, 2);
    private Double nabavnaVrednost = 0.0;
    private Double prodajnaVrednost = 0.0;
    private Trebovanje trebovanje;

    public StampaTrebovanjaNPC(Trebovanje trebovanje, TipTrebovanja tip, String nazivObjekta, String maticniBroj, String pib, String adresa) {
        super((Print)new EmptyPrint());
        this.fontName = "Tahoma";
        this.cellFont = new FontData(this.fontName, 7, 0);
        this.cellHeaderFont = new FontData(this.fontName, 7, 1);
        this.textFont = new FontData(this.fontName, 12, 0);
        this.titleFont = new FontData(this.fontName, 16, 1);
        this.trebovanje = trebovanje;
        super.setFooter(this.makeFooter());
        LinkedList<TwoTypeWrapper<String, String>> hData = new LinkedList<TwoTypeWrapper<String, String>>();
        TwoTypeWrapper<String, String> entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_NAZIV_OBJEKTA"), new Object[0]), nazivObjekta);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_MATICNI_BROJ"), new Object[0]), maticniBroj);
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_ADRESA"), new Object[0]), adresa != null ? adresa : "");
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>(String.format(Konstante.getBundle().getString("TEXT_PIB"), new Object[0]), pib);
        hData.add(entry);
        this.setHeader(this.makeHeader(tip, hData));
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add(16384, 0x1000000, (Print)new TextPrint(trebovanje.getTip().name() + ": " + trebovanje.getBrTrebovanja(), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(trebovanje.getTip().equals((Object)TipTrebovanja.OTPIS) ? "" : String.format(Konstante.getBundle().getString("TEXT_DOBAVLJAC"), new Object[0]) + ": " + (trebovanje.getDobavljac() != null ? trebovanje.getDobavljac().getNaziv() : ""), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]) + ": " + StatLogic.getDateString(trebovanje.getDatumTrebovanja()), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_DATUM_UNOSA"), new Object[0]) + ": " + StatLogic.getDateString(trebovanje.getDatumUnosa()), this.textFont, 16384));
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NAPOMENA"), new Object[0]) + ": " + trebovanje.getOpis(), this.textFont, 16384), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        body.add(this.makeDataGrid(trebovanje), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        this.setBody((Print)body);
        body.add((Print)new EmptyPrint(5, 5), -1);
        body.add((Print)new EmptyPrint());
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST"), new Object[0]) + ": " + StatLogic.getNumber02NG(this.nabavnaVrednost), this.textFont));
        body.add((Print)new EmptyPrint());
        body.add(16384, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST"), new Object[0]) + ": " + StatLogic.getNumber02NG(this.prodajnaVrednost), this.textFont));
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_ODGOVORNA_OSOBA"), new Object[0]), this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_KONTROLOR"), new Object[0]), this.textFont));
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add((Print)new NoBreakPrint(this.makeDataGridfoooter(this.trebovanje)), 1);
        return signature;
    }

    private Print makeDataGridfoooter(Trebovanje t) {
        GridPrint grid = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5), new GridColumn(131072, 1, 5)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        grid.setLook((GridLook)gl);
        this.addContentPorez(grid, t);
        return grid;
    }

    private Print makeDataGrid(Trebovanje t) {
        GridPrint grid = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 10), new GridColumn(16384, 1, 100), new GridColumn(0x1000000, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20), new GridColumn(131072, 1, 20)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        grid.setLook((GridLook)gl);
        this.addHeader(grid);
        this.addContent(grid, t);
        return grid;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_REDNI_BROJ_SKR"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NAZIV_ARTIKLA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_KOLICINA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_SA_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_CENA"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST_BEZ_PDV"), new Object[0]), this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_VREDNOST_SA_PDV"), new Object[0]), this.cellHeaderFont));
    }

    private void addContentPorez(GridPrint grid, Trebovanje t) {
        if (grid == null || t == null || t.getStavke() == null) {
            return;
        }
        Comparator<TrebovanjeStavka> cc = UpravljanjeTrebovanjem.psComp;
        LinkedList<TrebovanjeStavka> list = new LinkedList<TrebovanjeStavka>(t.getStavke());
        Collections.sort(list, cc);
        LinkedList<TrebovanjeStavka> deset = new LinkedList<TrebovanjeStavka>();
        LinkedList<TrebovanjeStavka> dvadeset = new LinkedList<TrebovanjeStavka>();
        for (TrebovanjeStavka ts : list) {
            if (ts.getPdvStopa().equals(10.0)) {
                deset.add(ts);
                continue;
            }
            if (!ts.getPdvStopa().equals(20.0)) continue;
            dvadeset.add(ts);
        }
        grid.add((Print)new TextPrint("stope", this.cellFont));
        grid.add((Print)new TextPrint("nabavna cena", this.cellFont));
        grid.add((Print)new TextPrint("nabavnaSaPDV", this.cellFont));
        grid.add((Print)new TextPrint("nabavni PDV", this.cellFont));
        grid.add((Print)new TextPrint("prodajna cena", this.cellFont));
        grid.add((Print)new TextPrint("prodajnaSaPDV", this.cellFont));
        grid.add((Print)new TextPrint("prodajni PDV", this.cellFont));
        double ukupnaNabavna1 = 0.0;
        double ukupnaNabavnaSaPdv1 = 0.0;
        double nabPorez1 = 0.0;
        double ukupnaProdajna1 = 0.0;
        double ukupnaProdajnaSaPdv1 = 0.0;
        double prodPorez1 = 0.0;
        for (TrebovanjeStavka t10 : deset) {
            ukupnaNabavna1 += t10.getUkupnoBPDV().doubleValue();
            ukupnaNabavnaSaPdv1 += t10.getUkupno().doubleValue();
            nabPorez1 += t10.getUkupno() - t10.getUkupnoBPDV();
            ukupnaProdajnaSaPdv1 += t10.getArtikal().getCena() * t10.getKolicina();
            ukupnaProdajna1 += t10.getArtikal().getCena() * t10.getKolicina() / 1.1;
            prodPorez1 += t10.getArtikal().getCena() * t10.getKolicina() - t10.getArtikal().getCena() * t10.getKolicina() / 1.1;
        }
        grid.add((Print)new TextPrint("10%", this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavna1), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavnaSaPdv1), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(nabPorez1), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajnaSaPdv1), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajna1), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(prodPorez1), this.cellFont));
        double ukupnaNabavna = 0.0;
        double ukupnaNabavnaSaPdv = 0.0;
        double nabPorez = 0.0;
        double ukupnaProdajna = 0.0;
        double ukupnaProdajnaSaPdv = 0.0;
        double prodPorez = 0.0;
        for (TrebovanjeStavka t20 : dvadeset) {
            ukupnaNabavna += t20.getUkupnoBPDV().doubleValue();
            ukupnaNabavnaSaPdv += t20.getUkupno().doubleValue();
            nabPorez += t20.getUkupno() - t20.getUkupnoBPDV();
            ukupnaProdajnaSaPdv += t20.getArtikal().getCena() * t20.getKolicina();
            ukupnaProdajna += t20.getArtikal().getCena() * t20.getKolicina() / 1.2;
            prodPorez += t20.getArtikal().getCena() * t20.getKolicina() - t20.getArtikal().getCena() * t20.getKolicina() / 1.2;
        }
        grid.add((Print)new TextPrint("20%", this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavna), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavnaSaPdv), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(nabPorez), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajnaSaPdv), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajna), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(prodPorez), this.cellFont));
        grid.add((Print)new TextPrint("Ukupno", this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavna + ukupnaNabavna1), this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaNabavnaSaPdv + ukupnaNabavnaSaPdv1), this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(nabPorez + nabPorez1), this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajnaSaPdv + ukupnaProdajnaSaPdv1), this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajna + ukupnaProdajna1), this.cellHeaderFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(prodPorez + prodPorez1), this.cellHeaderFont));
    }

    private void addContent(GridPrint grid, Trebovanje t) {
        if (grid == null || t == null || t.getStavke() == null) {
            return;
        }
        Comparator<TrebovanjeStavka> cc = UpravljanjeTrebovanjem.psComp;
        LinkedList<TrebovanjeStavka> list = new LinkedList<TrebovanjeStavka>(t.getStavke());
        Collections.sort(list, cc);
        Double nvbpdv = 0.0;
        double ukupnoNabavna = 0.0;
        double ukupnaProdajnaBezOdv = 0.0;
        double ukupnaProdajna = 0.0;
        int nextRB = 0;
        for (TrebovanjeStavka ts : list) {
            String rb = "";
            if (ts.getRedniBroj() == null) {
                if (list.indexOf(ts) == 0) {
                    nextRB = 1;
                }
                rb = "" + nextRB;
                ++nextRB;
            } else {
                rb = ts.getRedniBroj().toString();
            }
            grid.add((Print)new TextPrint("" + rb, this.cellFont));
            grid.add((Print)new TextPrint("" + ts.getArtikal().getName(), this.cellFont));
            grid.add((Print)new TextPrint("" + ts.getArtikal().getJedinicaMere(), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getKolicina()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getKomadBPDV()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getKomad()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getUkupnoBPDV()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getUkupno()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getArtikal().getCena() / ts.getArtikal().getMera()), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getArtikal().getCena() / ts.getArtikal().getMera() * ts.getKolicina() * 100.0 / (100.0 + ts.getPdvStopa())), this.cellFont));
            grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getArtikal().getCena() / ts.getArtikal().getMera() * ts.getKolicina()), this.cellFont));
            ukupnoNabavna += ts.getUkupno() / ts.getKolicina();
            nvbpdv = nvbpdv + ts.getUkupnoBPDV();
            ukupnaProdajnaBezOdv += ts.getArtikal().getCena() / ts.getArtikal().getMera() * ts.getKolicina() * 100.0 / (100.0 + ts.getPdvStopa());
            this.nabavnaVrednost = this.nabavnaVrednost + ts.getUkupno();
            this.prodajnaVrednost = ukupnaProdajna += ts.getArtikal().getCena() / ts.getArtikal().getMera() * ts.getKolicina();
        }
        grid.add(131072, 0x1000000, (Print)new TextPrint(String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]) + ":", this.cellHeaderFont), 6);
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(nvbpdv), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(this.nabavnaVrednost), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnoNabavna), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajnaBezOdv), this.cellFont));
        grid.add((Print)new TextPrint("" + StatLogic.getNumber03NG(ukupnaProdajna), this.cellFont));
    }

    public Trebovanje getTrebovanje() {
        return this.trebovanje;
    }

    public void setTrebovanje(Trebovanje trebovanje) {
        this.trebovanje = trebovanje;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaTrebovanjaNPC.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaTrebovanjaNPC.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format(Konstante.getBundle().getString("TEXT_STRANA"), new Object[0]) + " " + (pn.getPageNumber() + 1) + String.format(Konstante.getBundle().getString("TEXT_STRANA_UKUPNO_SPLITER"), new Object[0]) + pn.getPageCount();
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader(final TipTrebovanja tip, final List<TwoTypeWrapper<String, String>> podaci) {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 50), new GridColumn(16384, 1, 50)});
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                hgp.add(0x1000000, 0x1000000, (Print)new TextPrint(tip.getInterName(), StampaTrebovanjaNPC.this.titleFont, 0x1000000), -1);
                String s1 = StampaTrebovanjaNPC.this.trebovanje.getIz() != null ? StampaTrebovanjaNPC.this.trebovanje.getIz().getNaziv() : "";
                String s2 = StampaTrebovanjaNPC.this.trebovanje.getU() != null ? "--> " + StampaTrebovanjaNPC.this.trebovanje.getU().getNaziv() : "";
                hgp.add(0x1000000, 0x1000000, (Print)new TextPrint(s1 + s2, 0x1000000), -1);
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                if (podaci != null) {
                    for (int i = 0; i < podaci.size(); ++i) {
                        TwoTypeWrapper ttw = (TwoTypeWrapper)podaci.get(i);
                        Object p = ttw != null ? new TextPrint((String)ttw.getA() + ": " + (String)ttw.getB(), StampaTrebovanjaNPC.this.textFont) : new EmptyPrint();
                        hgp.add(16384, (Print)p);
                    }
                }
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                BorderPrint h = new BorderPrint((Print)hgp, (Border)new LineBorder());
                return h;
            }
        };
    }
}

