/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.NoBreakPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StampaTrebovanjaBA
extends PagePrint {
    private final String fontName;
    private final FontData titleFont;
    private final FontData textFont;
    private final FontData cellHeaderFont;
    private final FontData cellFont;
    private final FontData footerFont = new FontData(this.fontName, 6, 2);
    private Double nabavnaVrednost = 0.0;
    private Trebovanje trebovanje;

    public StampaTrebovanjaBA(Trebovanje trebovanje, TipTrebovanja tip, String nazivObjekta, String maticniBroj) {
        super((Print)new EmptyPrint());
        TwoTypeWrapper<String, String> entry;
        this.fontName = "Arial";
        this.cellFont = new FontData(this.fontName, 9, 0);
        this.cellHeaderFont = new FontData(this.fontName, 9, 1);
        this.textFont = new FontData(this.fontName, 10, 1);
        this.titleFont = new FontData(this.fontName, 16, 1);
        this.trebovanje = trebovanje;
        super.setFooter(this.makeFooter());
        LinkedList<TwoTypeWrapper<String, String>> hData = new LinkedList<TwoTypeWrapper<String, String>>();
        if (trebovanje.getPrijemnica() != null) {
            entry = new TwoTypeWrapper<String, String>("KOMITENT", trebovanje.getPrijemnica().getDobavljac().getNaziv());
            hData.add(entry);
            hData.add(null);
        }
        entry = new TwoTypeWrapper<String, String>("VRSTA PROMJENE", trebovanje.getTip() != null && trebovanje.getTip().getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI ? "IZLAZ" : "ULAZ");
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("RA\u010cUN", trebovanje.getBrTrebovanja());
        hData.add(entry);
        entry = new TwoTypeWrapper<String, String>("SKLADI\u0160TE", trebovanje.getTip().getTipDokumenta() == TipTrebovanja.DokumentAtribut.IZLAZNI ? trebovanje.getIz().getNaziv() : trebovanje.getU().getNaziv());
        hData.add(entry);
        hData.add(null);
        this.setHeader(this.makeHeader(nazivObjekta, trebovanje.getDatumTrebovanja(), hData));
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 100), new GridColumn(16384, 1, 100)});
        body.setLook((GridLook)new DefaultGridLook(0, 5));
        body.add(this.makeDataGrid(trebovanje), -1);
        body.add((Print)new EmptyPrint(10, 10), -1);
        this.setBody((Print)body);
        body.add((Print)new EmptyPrint(5, 5), -1);
        body.add((Print)new NoBreakPrint(this.makeSignature()), -1);
    }

    private Print makeSignature() {
        GridPrint signature = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 1, 50), new GridColumn(0x1000000, 1, 50)});
        signature.add((Print)new EmptyPrint(15, 15), -1);
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("IZDAO", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("PREUZEO", this.textFont));
        signature.add((Print)new EmptyPrint(5, 5));
        signature.add((Print)new EmptyPrint(5, 5));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        signature.add(0x1000000, 0x1000000, (Print)new TextPrint("______________________________", this.textFont));
        return signature;
    }

    private Print makeDataGrid(Trebovanje t) {
        GridPrint grid = new GridPrint(new GridColumn[]{new GridColumn(131072, 1, 10), new GridColumn(16384, 1, 50), new GridColumn(0x1000000, 1, 150), new GridColumn(131072, 1, 17), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30), new GridColumn(131072, 1, 30)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setCellBorder((Border)new LineBorder(new RGB(64, 64, 64)));
        gl.setHeaderBackground(new RGB(96, 197, 255));
        grid.setLook((GridLook)gl);
        this.addHeader(grid);
        this.addContent(grid, t);
        return grid;
    }

    private void addHeader(GridPrint grid) {
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("RBR", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("\u0160IFRA", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("NAZIV ARTIKLA", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("JM", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("KOLI\u010cINA", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("FAKT. CIJENA", this.cellHeaderFont));
        grid.addHeader(0x1000000, 0x1000000, (Print)new TextPrint("FAKT. IZNOS", this.cellHeaderFont));
    }

    private void addContent(GridPrint grid, Trebovanje t) {
        if (grid == null || t == null || t.getStavke() == null) {
            return;
        }
        Comparator<TrebovanjeStavka> cc = UpravljanjeTrebovanjem.psComp;
        LinkedList<TrebovanjeStavka> list = new LinkedList<TrebovanjeStavka>(t.getStavke());
        Collections.sort(list, cc);
        int nextRB = 0;
        for (TrebovanjeStavka ts : list) {
            String rb = "";
            if (ts.getRedniBroj() == null) {
                if (list.indexOf(ts) == 0) {
                    nextRB = 1;
                }
                rb = "" + nextRB;
                ++nextRB;
            } else {
                rb = ts.getRedniBroj().toString();
            }
            grid.add(131072, 0x1000000, (Print)new TextPrint("" + rb, this.cellFont, 131072));
            grid.add(131072, 0x1000000, (Print)new TextPrint("" + (ts.getArtikal().getBarCode() == null ? "" : ts.getArtikal().getBarCode()), this.cellFont, 131072));
            grid.add(16384, 0x1000000, (Print)new TextPrint("" + ts.getArtikal().getName(), this.cellFont, 16384));
            grid.add(0x1000000, 0x1000000, (Print)new TextPrint("" + ts.getArtikal().getJedinicaMere(), this.cellFont, 0x1000000));
            grid.add(131072, 0x1000000, (Print)new TextPrint("" + StatLogic.getNumber03NG(ts.getKolicina()), this.cellFont, 131072));
            grid.add(131072, 0x1000000, (Print)new TextPrint("" + StatLogic.getNumber02NG(ts.getKomad()), this.cellFont, 131072));
            grid.add(131072, 0x1000000, (Print)new TextPrint("" + StatLogic.getNumber02NG(ts.getUkupno()), this.cellFont, 131072));
            this.nabavnaVrednost = this.nabavnaVrednost + ts.getUkupno();
        }
        grid.add(16384, 0x1000000, (Print)new TextPrint("UKUPNO ZA DOKUMENT:", this.cellHeaderFont, 16384), 6);
        grid.add((Print)new TextPrint("" + StatLogic.getNumber02NG(this.nabavnaVrednost), this.cellFont));
    }

    public Trebovanje getTrebovanje() {
        return this.trebovanje;
    }

    public void setTrebovanje(Trebovanje trebovanje) {
        this.trebovanje = trebovanje;
    }

    private PageDecoration makeFooter() {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint print = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 50), new GridColumn(131072, -1, 50)});
                print.add(16384, 1024, (Print)new TextPrint(StatLogic.getDateTimeString(new Date()), StampaTrebovanjaBA.this.footerFont, 16384));
                PageNumberPrint pnp = new PageNumberPrint(pn, StampaTrebovanjaBA.this.footerFont, 131072);
                pnp.setPageNumberFormat(new PageNumberFormat(){

                    public String format(PageNumber pn) {
                        return String.format(Konstante.getBundle().getString("TEXT_STRANA"), new Object[0]) + " " + (pn.getPageNumber() + 1) + String.format(Konstante.getBundle().getString("TEXT_STRANA_UKUPNO_SPLITER"), new Object[0]) + pn.getPageCount();
                    }
                });
                print.add(131072, 1024, (Print)pnp);
                return print;
            }
        };
    }

    private PageDecoration makeHeader(final String nazivObjekta, final Date datumTrebovanja, final List<TwoTypeWrapper<String, String>> podaci) {
        return new PageDecoration(){

            public Print createPrint(PageNumber pn) {
                GridPrint hgp = new GridPrint(new GridColumn[]{new GridColumn(16384, 1, 50), new GridColumn(16384, 1, 50)});
                hgp.add(16384, 0x1000000, (Print)new TextPrint(nazivObjekta, StampaTrebovanjaBA.this.textFont, 16384));
                hgp.add(131072, 0x1000000, (Print)new TextPrint("Datum: " + StatLogic.getDateString(datumTrebovanja), StampaTrebovanjaBA.this.textFont, 131072));
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                hgp.add(0x1000000, 0x1000000, (Print)new TextPrint("Prijemnica - 34", StampaTrebovanjaBA.this.titleFont, 0x1000000), -1);
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                if (podaci != null) {
                    for (TwoTypeWrapper ttw : podaci) {
                        Object p = ttw != null ? new TextPrint((String)ttw.getA() + ": " + (String)ttw.getB(), StampaTrebovanjaBA.this.textFont, 16384) : new EmptyPrint();
                        hgp.add(16384, (Print)p);
                    }
                }
                hgp.add((Print)new EmptyPrint(5, 5), -1);
                return hgp;
            }
        };
    }
}

