/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.fiscal.FiscalPrinter;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.NumUtils;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StampaPorudzbine;
import com.dev63.restoran.stampa.StampaPorudzbine2;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class StampaStorna {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    File print;
    File stornoF;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    String naziv;
    RestoranServer server;
    Storno storno;
    boolean odstampanazbirna = false;
    FiscalPrinter fiscal;

    public StampaStorna(Storno storno, Restoran restoran) {
        try {
            this.storno = storno;
            Setting objekat = restoran.getServer().getSetting(Option.OBJEKAT_NAZIV);
            this.naziv = objekat == null ? "" : objekat.stringValue();
            Map mapa = StavkeSumarno.MakeMap2(storno, restoran);
            this.server = restoran.getServer();
            this.fiscal = restoran.getFiscal();
            Set set = mapa.keySet();
            for (Odeljenje o : set) {
                if (o.getStampac() == null) continue;
                System.out.println("o = " + o);
                System.out.println("mapa.get(o) = " + mapa.get(o));
                String content = this.writeContent((List)mapa.get(o), o, o.getStampac().getTip().getBrojDodatnihLinija(), o.getStampac().getTip().getBrojKarakteraURedu());
                if (content == null) {
                    return;
                }
                NPrintUtils.printContent(content, o.getStampac(), 2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void printFromStringHCP(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void printFromStringRMI(String stampac, String print, int brojKarakteraURedu) {
        try {
            XMLWriter.writeNonFiscal(NPrintUtils.stringToList(print, brojKarakteraURedu));
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String writeInString(List<StornoStavka> stavke, Odeljenje o, int extraLinija, int brojKarakteraURedu) {
        int bkur = brojKarakteraURedu;
        char[] mla = new char[bkur];
        Arrays.fill(mla, '-');
        String print = "";
        String stornoS = String.format(this.barmasterText.getString("TEXT_STORNO"), new Object[0]) + "!";
        String line = "";
        int len = 0;
        while (len + 1 + stornoS.length() < brojKarakteraURedu) {
            line = line + stornoS + " ";
            len += stornoS.length();
        }
        print = print + NPrintUtils.centerText(bkur, line);
        print = print + NPrintUtils.centerText(bkur, this.naziv);
        print = print + NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date()));
        print = print + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + ": " + Konstante.getNazivStola(this.storno.getBrojStola(), this.server));
        print = print + NPrintUtils.centerText(bkur, o.getNaziv());
        print = print + new String(mla);
        for (StornoStavka sr : stavke) {
            print = print + NPrintUtils.leftText(10, StatLogic.getNumber03NG(sr.getKolicina()) + "x ") + NPrintUtils.leftText(bkur - 10, sr.getArtikal().getName());
        }
        print = print + new String(mla);
        print = print + NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + this.storno.getKonobar().getPunoime());
        print = print + NPrintUtils.centerText(bkur, line);
        for (int i = 0; i < extraLinija; ++i) {
            print = print + NPrintUtils.centerText(bkur, "");
        }
        return print;
    }

    public void printFromString(String stampac, String print) {
        try {
            XMLWriterHCP.writeNonFiscal(print);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeInFile(String putanja, List<StornoStavka> stavke, Odeljenje o, int extraLinija, int brojKarakteraURedu) {
        try {
            int bkur = brojKarakteraURedu;
            this.fos = new FileOutputStream(this.stornoF);
            PrintStream ps = new PrintStream(this.fos);
            char[] mla = new char[bkur];
            Arrays.fill(mla, '-');
            String stornoS = String.format(this.barmasterText.getString("TEXT_STORNO"), new Object[0]) + "!";
            String line = "";
            int len = 0;
            while (len + 1 + stornoS.length() < brojKarakteraURedu) {
                line = line + stornoS + " ";
                len += stornoS.length();
            }
            ps.println(NPrintUtils.centerText(bkur, line));
            ps.println(NPrintUtils.centerText(bkur, this.naziv));
            ps.println(NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())));
            ps.println(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + ": " + Konstante.getNazivStola(this.storno.getBrojStola(), this.server)));
            ps.println(NPrintUtils.centerText(bkur, o.getNaziv()));
            ps.println(new String(mla));
            for (StornoStavka sr : stavke) {
                ps.println(NPrintUtils.leftText(10, StatLogic.getNumber03NG(sr.getKolicina()) + "x ") + NPrintUtils.leftText(bkur - 10, sr.getArtikal().getName()));
            }
            ps.println(new String(mla));
            ps.println(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + this.storno.getKonobar().getPunoime()));
            ps.println(NPrintUtils.centerText(bkur, line));
            for (int i = 0; i < extraLinija; ++i) {
                ps.println();
            }
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String writeContent(List<StornoStavka> stavke, Odeljenje o, int extraLinija, int brojKarakteraURedu) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bkur = brojKarakteraURedu;
            PrintStream ps = new PrintStream(baos);
            char[] mla = new char[bkur];
            Arrays.fill(mla, '-');
            String stornoS = String.format(Konstante.getBundle().getString("TEXT_STORNO_HEADER_STAMPA"), new Object[0]) + "!";
            String line = "";
            int len = 0;
            while (len + 1 + stornoS.length() <= brojKarakteraURedu) {
                line = line + stornoS + " ";
                len += stornoS.length() + 1;
            }
            if (line.length() > 0) {
                line = line.substring(0, line.length() - 1);
            }
            ps.println(NPrintUtils.centerText(bkur, line));
            ps.println(NPrintUtils.spaceFill(bkur));
            if (this.naziv != null && this.naziv.length() > 0) {
                ps.println(NPrintUtils.centerText(bkur, this.naziv));
            }
            ps.println(NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())));
            ps.println(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + ": " + Konstante.getNazivStola(this.storno.getBrojStola(), this.server)));
            ps.println(NPrintUtils.centerText(bkur, o.getNaziv()));
            ps.println(NPrintUtils.minusFill(bkur));
            for (StornoStavka sr : stavke) {
                if (sr.getParent() != null) continue;
                ps.println(NPrintUtils.leftText(10, StatLogic.getNumber03NG(sr.getKolicina()) + "x ") + NPrintUtils.leftText(bkur - 10, sr.getArtikal().getName()));
                if (sr.getChildren() == null) continue;
                for (StornoStavka child : sr.getChildren()) {
                    double kolicinaC = NumUtils.round(sr.getKolicina() == 0.0 ? child.getKolicina() : child.getKolicina() / sr.getKolicina(), 3);
                    ps.println(NPrintUtils.leftText(12, "--".concat(StatLogic.getNumber03NG(kolicinaC)).concat("x ")).concat(NPrintUtils.leftText(bkur - 12, child.getArtikal().getName())));
                }
            }
            ps.println(NPrintUtils.minusFill(bkur));
            ps.println(NPrintUtils.centerText(bkur, String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]) + ": " + this.storno.getKonobar().getPunoime()));
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.centerText(bkur, line));
            String content = baos.toString();
            baos.close();
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                baos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
    }

    public void printFromFile(String putanja, Stampac stampac) {
        try {
            byte[] by;
            if (stampac.getNaziv().equals(TipStampaca.FP550.toString())) {
                String strLine;
                this.fis = new FileInputStream(this.stornoF);
                DataInputStream in = new DataInputStream(this.fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> text = new ArrayList<String>();
                while ((strLine = br.readLine()) != null) {
                    text.add(strLine);
                }
                XMLWriter.writeNonFiscal(text);
                return;
            }
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.stornoF);
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            switch (stampac.getTip()) {
                case STARTCP100: {
                    by = new byte[]{27, 100, 51};
                    break;
                }
                default: {
                    by = new byte[]{27, 105};
                }
            }
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaPorudzbine.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

