/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostPretplata;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.StoNaziv;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class StampaStalniGostPretplata {
    private Stampac stampac;
    private int brojKopija;
    private StoNaziv sn;
    double iznosRacuna;
    RestoranServer server;
    private Kasa kasa;
    private StalniGostPretplata sgp;
    private List<StavkaRacuna> st;
    private boolean stampajArtikle = false;
    private StalniGost sg;

    public StampaStalniGostPretplata(StalniGostPretplata sgp, List<StavkaRacuna> stavke, double iznosRacuna, Stampac stampac, int brojKopija, Kasa kasa, RestoranServer server) {
        this.iznosRacuna = iznosRacuna;
        this.stampac = stampac;
        this.brojKopija = brojKopija;
        this.server = server;
        this.kasa = kasa;
        this.sgp = sgp;
        this.st = stavke;
        this.sg = sgp.getStalniGost();
        this.stampajArtikle = BMTerminalSettings.getSetting(OptionBO.PRETPLATA_ARTIKLI).booleanValue();
        this.writeInFile(this.st, iznosRacuna, brojKopija, stampac.getTip().getBrojDodatnihLinija(), stampac.getTip().getBrojKarakteraURedu(), server);
    }

    public void writeInFile(List<StavkaRacuna> stavke, double iznosRacuna, int brojKopija, int extraLinija, int brojKarakteraURedu, RestoranServer server) {
        Date datum = new Date();
        char[] ela = new char[brojKarakteraURedu];
        char[] mla = new char[brojKarakteraURedu];
        char[] ula = new char[brojKarakteraURedu];
        Arrays.fill(ela, '=');
        Arrays.fill(mla, '-');
        Arrays.fill(ula, '_');
        String content = "";
        this.iznosRacuna = iznosRacuna;
        content = content + new String(ela);
        content = content + "\n";
        content = content + new StringAlign(11, 108).format(StatLogic.getDateString(new Date())) + new StringAlign(brojKarakteraURedu - 11, 114).format(StatLogic.getTimeString(new Date()));
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(Konstante.getBundle().getString("TEXT_PRODAJNO_MESTO") + ": " + this.kasa.getProdajnoMesto().getNaziv());
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(Konstante.getBundle().getString("TEXT_KASA") + ": " + this.kasa.getOznaka());
        content = content + "\n";
        content = content + "\n";
        content = content + new StringAlign(brojKarakteraURedu, 99).format(Konstante.getBundle().getString("TEXT_POTROSNJA_PO_PRETPLATI"));
        if (this.stampajArtikle) {
            content = content + "\n";
            content = content + "\n";
            content = content + new String(ela);
            double vr = 0.0;
            for (StavkaRacuna sr : stavke) {
                boolean prices = true;
                content = content + this.printOrderItemLine(brojKarakteraURedu, sr, prices);
                if (sr.getPodStavke() != null && !sr.getPodStavke().isEmpty()) {
                    for (StavkaRacuna child : sr.getPodStavke()) {
                        content = content + this.printOrderItemLine(brojKarakteraURedu, child, prices);
                        if (!prices) continue;
                        vr += child.getVrednost().doubleValue();
                    }
                }
                if (sr.getOpis() != null) {
                    String[] opisi;
                    for (String s : opisi = sr.getOpis().split(", ")) {
                        content = content + NPrintUtils.leftText(brojKarakteraURedu, " ** " + s).concat("\n");
                    }
                }
                if (!prices) continue;
                vr += sr.getVrednost().doubleValue();
            }
        }
        content = content + "\n";
        content = content + "\n";
        content = content + new String(ela);
        content = content + "\n";
        content = content + "Potroseno:" + new StringAlign(brojKarakteraURedu - 10, 114).format("" + iznosRacuna);
        content = content + "\n";
        content = content + "\n";
        content = content + "Korisnik:" + new StringAlign(brojKarakteraURedu - 10, 114).format(this.sgp.getStalniGost().getNaziv());
        content = content + "\n";
        content = content + "\n";
        content = content + "             _________________\n";
        content = content + "\n";
        content = content + new String(ela);
        content = content + "\n";
        content = content + "Ostatak:" + new StringAlign(brojKarakteraURedu - 10, 114).format("" + this.sgp.getPretplata());
        content = content + "\n";
        content = content + new String(ela);
        content = content + "\n";
        content = content + "\n";
        content = content + "\n";
        content = content + "\n";
        content = content + "\n";
        NPrintUtils.printContent(content, this.stampac, brojKopija);
    }

    private String printOrderItemLine(int bkur, StavkaRacuna sr, boolean prices) {
        StringBuilder t2 = new StringBuilder();
        StavkaRacuna parent = sr.getGlavnaStavka();
        String prefix = parent != null ? "--" : "";
        BigDecimal parentKol = parent != null ? BigDecimal.valueOf(parent.getKolicina()) : BigDecimal.ONE;
        BigDecimal kol = BigDecimal.valueOf(sr.getKolicina());
        kol = kol.divide(parentKol, 3, RoundingMode.HALF_UP);
        String kolicina = "";
        if (parentKol.compareTo(BigDecimal.ONE) != 0) {
            kolicina = kolicina.concat("(").concat(StatLogic.getNumber03NGF(parentKol)).concat("x)");
        }
        kolicina = kolicina.concat(StatLogic.getNumber03NGF(kol).concat("x "));
        int[] colLen = new int[prices ? 4 : 2];
        int i = 0;
        if (prices) {
            colLen[i++] = bkur - prefix.length();
            colLen[i++] = bkur - 16;
            colLen[i++] = 7;
            colLen[i++] = 9;
            i = 0;
            t2.append(prefix);
            t2.append(NPrintUtils.leftText(colLen[i++], sr.getArtikal().getSkrNaziv()));
            t2.append("\n");
            t2.append(NPrintUtils.rightText(colLen[i++], kolicina));
            t2.append(NPrintUtils.rightText(colLen[i++], StatLogic.getNumber02NG(sr.getCena() != null ? sr.getCena() : sr.getArtikal().getCena())));
            t2.append(NPrintUtils.rightText(colLen[i++], StatLogic.getNumber02NG(sr.getVrednost())));
            t2.append("\n");
        } else {
            colLen[i++] = kolicina.length();
            colLen[i++] = bkur - prefix.length() - kolicina.length();
            i = 0;
            t2.append(prefix);
            t2.append(NPrintUtils.leftText(colLen[i++], kolicina));
            if (sr.getArtikal().getSkrNaziv().length() > bkur - prefix.length() - kolicina.length()) {
                String[] s = sr.getArtikal().getSkrNaziv().trim().split("\\s+");
                String gore = "";
                for (int a = 0; a < s.length - 1; ++a) {
                    gore = gore + " " + s[a];
                }
                String dole = s[s.length - 1];
                t2.append(NPrintUtils.leftText(colLen[i++], gore.trim()) + "\n");
                i = 0;
                t2.append(NPrintUtils.leftText(colLen[i++], ""));
                t2.append(NPrintUtils.leftText(colLen[i++], dole));
            } else {
                t2.append(NPrintUtils.leftText(colLen[i++], sr.getArtikal().getSkrNaziv()));
            }
            t2.append("\n");
        }
        return t2.toString();
    }
}

