/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.stampa;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.TipStampaca;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.stampa.StringAlign;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;

public class StampaPrometSvihKonobara {
    File print;
    FileOutputStream fos = null;
    FileInputStream fis = null;
    RestoranServer server;
    Stampac stampac;
    Date d1;
    Date d2;
    List<String> crnaPlacanja;

    public StampaPrometSvihKonobara(Map<Konobar, Double> iznosStorno, Map<Konobar, Double> pazar, Map<String, Integer> racuniBR, List<Konobar> konobari, Restoran restoran, Date day1, Date day2) {
        this.server = restoran.getServer();
        this.print = new File(System.getProperty("user.home"));
        this.print = new File(this.print, "restoran_print");
        this.crnaPlacanja = new LinkedList<String>();
        this.d1 = day1;
        this.d2 = day2;
        for (CrnoPlacanje crnoPlacanje : this.server.readCrnaPlacanja()) {
            this.crnaPlacanja.add(crnoPlacanje.getNaziv());
        }
        if (!this.print.isDirectory()) {
            this.print.mkdir();
        }
        try {
            this.stampac = this.server.readIzvestajiStampacObject();
            if (this.stampac != null) {
                String content = this.writeContent(iznosStorno, pazar, konobari, racuniBR, this.stampac.getTip().getBrojDodatnihLinija(), this.stampac.getTip().getBrojKarakteraURedu());
                NPrintUtils.printContent(content, this.stampac, 1);
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeInFile(Map<Konobar, Double> iznosStorno, Map<Konobar, Double> pazar, List<Konobar> konobari, Map<String, Integer> racuniBR, int extraLinija) {
        try {
            void var13_18;
            this.fos = new FileOutputStream(this.print.getCanonicalPath() + "\\konobari.txt");
            PrintStream ps = new PrintStream(this.fos);
            String od = "Sva proizvodna mesta";
            ps.println(Konstante.getDate(new Date()) + "\t\t" + Konstante.getfullTime(new Date()));
            ps.println(StringUtils.center((String)"PROMET PO KONOBARIMA", (int)34));
            ps.println(StringUtils.center((String)od, (int)34));
            ps.println(StringUtils.center((String)"Za period", (int)34));
            ps.println(StringUtils.right((String)("Od: " + StatLogic.getDateString(this.d1)), (int)17) + StringUtils.left((String)(" Do: " + StatLogic.getDateString(this.d2)), (int)17));
            ps.println();
            ps.println(new StringAlign(14, 108).format("KONOBAR") + new StringAlign(9, 108).format("IZNOS") + new StringAlign(10, 114).format("PAZAR"));
            ps.println(new StringAlign(14, 108).format(" ") + new StringAlign(10, 108).format("STORNA"));
            ps.println("---------------------------------");
            double is = 0.0;
            double pa = 0.0;
            for (Konobar konobar : konobari) {
                ps.println(new StringAlign(14, 108).format(konobar.getPunoime()) + new StringAlign(9, 108).format(Konstante.getNumber2(iznosStorno.get(konobar))) + new StringAlign(10, 114).format(Konstante.getNumber2(pazar.get(konobar))));
                is += iznosStorno.get(konobar).doubleValue();
                pa += pazar.get(konobar).doubleValue();
            }
            ps.println("---------------------------------");
            ps.println(new StringAlign(14, 108).format("TOTAL") + new StringAlign(9, 108).format(Konstante.getNumber2(is)) + new StringAlign(10, 114).format(Konstante.getNumber2(pa)));
            ps.println("---------------------------------");
            ps.println();
            ps.println("Nacin placanja" + new StringAlign(18, 114).format("Broj racuna"));
            boolean ukupnoRacuna = false;
            System.out.println("" + racuniBR.size());
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!racuniBR.containsKey(np.name())) continue;
                String nacinPlacanja = "";
                nacinPlacanja = np == NacinPlacanja.GOTOVINA ? "GOTOV." : (np.name().equalsIgnoreCase("KARTICA") ? "KART." : (np.name().equalsIgnoreCase("CEK") ? "CHECK" : "FAKTURA"));
                ps.println(nacinPlacanja + new StringAlign(32 - nacinPlacanja.length(), 114).format(racuniBR.get(np.name()).toString()));
            }
            for (String cp : this.crnaPlacanja) {
                if (!racuniBR.containsKey(cp)) continue;
                String nacinPlacanja = cp;
                ps.println(nacinPlacanja + new StringAlign(32 - nacinPlacanja.length(), 114).format(racuniBR.get(cp).toString()));
            }
            ps.println();
            ps.println("---------------");
            ps.println(new StringAlign(15, 99).format("predao"));
            boolean bl = false;
            while (var13_18 < extraLinija) {
                ps.println();
                ++var13_18;
            }
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StampaPrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String writeContent(Map<Konobar, Double> iznosStorno, Map<Konobar, Double> pazar, List<Konobar> konobari, Map<String, Integer> racuniBR, int extraLinija, int bkur) {
        String content = "";
        try {
            void var16_20;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            String od = String.format(Konstante.getBundle().getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]);
            ps.println(NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())));
            ps.println(NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_PROMET_SVIH_KONOBARA"), new Object[0])));
            ps.println(NPrintUtils.centerText(bkur, od));
            ps.println(NPrintUtils.centerText(bkur, String.format(Konstante.getBundle().getString("TEXT_ZA_PERIOD"), new Object[0])));
            ps.println(NPrintUtils.centerSplitToMiddle(bkur, String.format(Konstante.getBundle().getString("TEXT_OD"), new Object[0]) + ": " + StatLogic.getDateString(this.d1), " " + String.format(Konstante.getBundle().getString("TEXT_DO"), new Object[0]) + ": " + StatLogic.getDateString(this.d2)));
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.leftText(bkur - 9 - 10, String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0])) + NPrintUtils.rightText(9, String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0])) + NPrintUtils.rightText(10, String.format(Konstante.getBundle().getString("TEXT_PAZAR"), new Object[0])));
            ps.println(NPrintUtils.rightText(bkur - 10, String.format(Konstante.getBundle().getString("TEXT_STORNO"), new Object[0])) + NPrintUtils.rightText(10, ""));
            ps.println(NPrintUtils.minusFill(bkur));
            double is = 0.0;
            double pa = 0.0;
            for (Konobar konobar : konobari) {
                ps.println(NPrintUtils.leftText(bkur - 9 - 10, konobar.getPunoime()) + NPrintUtils.rightText(9, StatLogic.getNumber02NG(iznosStorno.get(konobar))) + NPrintUtils.rightText(10, StatLogic.getNumber02NG(pazar.get(konobar))));
                is += iznosStorno.get(konobar).doubleValue();
                pa += pazar.get(konobar).doubleValue();
            }
            ps.println(NPrintUtils.minusFill(bkur));
            ps.println(NPrintUtils.leftText(bkur - 9 - 10, String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0])) + NPrintUtils.rightText(9, StatLogic.getNumber02NG(is)) + NPrintUtils.rightText(10, StatLogic.getNumber02NG(pa)));
            ps.println(NPrintUtils.minusFill(bkur));
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.centerSplitToEnds(bkur, String.format(Konstante.getBundle().getString("TEXT_NACIN_PLACANJA"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA"), new Object[0])));
            boolean ukupnoRacuna = false;
            System.out.println("" + racuniBR.size());
            for (NacinPlacanja np : NacinPlacanja.values()) {
                if (!racuniBR.containsKey(np.name())) continue;
                String nacinPlacanja = np.getOpis();
                ps.println(NPrintUtils.centerSplitToEnds(bkur, nacinPlacanja, racuniBR.get(np.name()).toString()));
            }
            for (String cp : this.crnaPlacanja) {
                if (!racuniBR.containsKey(cp)) continue;
                String nacinPlacanja = cp;
                ps.println(NPrintUtils.centerSplitToEnds(bkur, nacinPlacanja, racuniBR.get(cp).toString()));
            }
            ps.println(NPrintUtils.spaceFill(bkur));
            ps.println(NPrintUtils.centerSplitToEnds(bkur, NPrintUtils.minusFill(bkur), ""));
            ps.println(NPrintUtils.centerSplitToCenter(bkur, String.format(Konstante.getBundle().getString("TEXT_PREDAO"), new Object[0]), ""));
            boolean bl = false;
            while (var16_20 < extraLinija) {
                ps.println(NPrintUtils.spaceFill(bkur));
                ++var16_20;
            }
            content = baos.toString();
            ps.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public void printFromFile() {
        String stampacN = this.stampac.getNaziv();
        if (stampacN.equals(TipStampaca.FP550.toString()) || stampacN.equals(TipStampaca.HCPP2DS.toString()) || stampacN.equals(TipStampaca.HCPBEST.toString())) {
            return;
        }
        try {
            byte[] by;
            DocFlavor flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
            DocPrintJob pj = null;
            DocPrintJob pj2 = null;
            for (PrintService printer : pservices) {
                if (!printer.getName().toUpperCase().contains(this.stampac.getNaziv().toUpperCase())) continue;
                pj = printer.createPrintJob();
                pj2 = printer.createPrintJob();
            }
            this.fis = new FileInputStream(this.print.getCanonicalPath() + "\\konobari.txt");
            SimpleDoc doc = new SimpleDoc(this.fis, flavor, null);
            pj.print(doc, aset);
            this.fis.close();
            flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            switch (this.stampac.getTip()) {
                case STARTCP100: {
                    by = new byte[]{27, 100, 51};
                    break;
                }
                default: {
                    by = new byte[]{27, 105};
                }
            }
            SimpleDoc doc2 = new SimpleDoc(by, flavor, null);
            pj2.print(doc2, aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                this.fis.close();
            }
            catch (IOException ex1) {
                Logger.getLogger(StampaPrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }
}

